{
            // ensure that T is not a ReaderWriterLock.
            is_not<T, System::Threading::ReaderWriterLock>::__dont_use_this_type__;
        }
#endif /* if !defined(_M_CEE_SAFE) */

        // release the lock if it is not currently held
        ~lock()
        {
            release();
        }

        // Check to see if this lock object is currently holding the lock
        bool is_locked()
        {
            return m_locked;
        }

        // Check to see if this lock object is currently holding the lock
        operator _detail_class::_safe_bool()
        {
            return is_locked() ? _detail_class::_safe_true : _detail_class::_safe_false;
        }

        // disallow explicit comparisons to _safe_bool
        template<class T> bool operator==( T t )
        {
            // ensure that T is not a _safe_bool.
            is_not<T, _detail_class::_safe_bool>::__dont_use_this_type__;

            return m_object == t;
        }

        template<class T> bool operator!=( T t )
        {
            // ensure that T is not a _safe_bool.
            is_not<T, _detail_class::_safe_bool>::__dont_use_this_type__;

            return m_object != t;
        }

        // Take the lock within the specified timespan, or with an infinite
        // timespan if none is specified. Throw an ApplicationException on timeout.
        void acquire( int _timeout )
        {
            if( ! m_locked )
            {
                if( ! System::Threading::Monitor::TryEn