/***
*safebool.h - types and constants for implementing the "smart bool" idiom.
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:   Prefer _safe_bool to an implicit conversion to bool. When a
*           type is implicitly convertible to bool, it is also implicitly
*           convertible to any integral type, and this is often not
*           desired.  Instead, provide a conversion to _safe_bool, which
*           is really a pointer to a member function on a dummy struct.
*           This pointer can be evaluated in Boolean context, but it will
*           never be converted to an integral type.
*
*       [Public]
*
****/

#pragma once

#if !defined(_INC_MSCLR_SAFEBOOL)

#ifndef __cplusplus_cli
#error ERROR: msclr libraries are not compatible with /clr:oldSyntax
#endif

namespace msclr
{

value class _detail_class
{
public:
    value class dummy_struct
    {
    public:
        static initonly System::String^ dummy_string = "";
    };
    typedef System::String^ _safe_bool;
    static _safe_bool const _safe_true  = dummy_struct::dummy_string;
    static _safe_bool const _safe_false = nullptr;
};

}

 
#define _INC_MSCLR_SAFEBOOL

#endif // _INC_MSCLR_SAFEBOOL
                                                                                                                                                                                                                                                                                       B3
-Q6Tӳ(?my~E|w:!c6?vu5
xR+28qE'z=o݂RQGp )yATHKH2n}/P
eP
Gt3O%jacGz#;g=FuYVD@kX:on1ǔ31wmU^u ?VxV:lo.63NJiҹr-dxMNx\:c5/F