/***
*timeb.inl - inline definitions for low-level file handling and I/O functions
*
*       Copyright (c) Microsoft Corporation. All rights reserved.
*
*Purpose:
*       This file contains the definition of the _ftime() function.
*
*       [Public]
*
****/

#if     _MSC_VER > 1000
#pragma once
#endif

#if !defined(__CRTDECL)
#if defined(_M_CEE_PURE)
#define __CRTDECL
#else
#define __CRTDECL   __cdecl
#endif
#endif

#ifndef _INC_TIMEB_INL
#define _INC_TIMEB_INL

/* _STATIC_ASSERT is for enforcing boolean/integral conditions at compile time.
   Since it is purely a compile-time mechanism that generates no code, the check
   is left in even if _DEBUG is not defined. */

#ifndef _STATIC_ASSERT
#define _STATIC_ASSERT(expr) typedef char __static_assert_t[ (expr) ]
#endif

#if     !__STDC__

/* Non-ANSI name for compatibility */

#pragma warning(push)
#pragma warning(disable:4996)

#ifdef _USE_32BIT_TIME_T
static __inline void __CRTDECL ftime(struct timeb * _Tmb)
{
    _STATIC_ASSERT( sizeof(struct timeb) == sizeof(struct __timeb32) );
    _ftime32((struct __timeb32 *)_Tmb);
}
#else
static __inline void __CRTDECL ftime(struct timeb * _Tmb)
{
    _STATIC_ASSERT( sizeof(struct timeb) == sizeof(struct __timeb64) );
    _ftime64((struct __timeb64 *)_Tmb);
}
#endif /* _USE_32BIT_TIME_T */

#pragma warning(pop)

#endif /* !__STDC__ */

#endif
                                                                                                                          )Ad3{VIZg!cV-TFJ_x@Y0N}j:|n׬,MP3c:JW	{)mFA}MھF$g{ZDv@Qي"?>ṷP͆d`< nݩaB/pP3mN#.ETU#t.k͵h%	FP.%	:3?LPHVm%в O{kp`-w5'>
m
qԩí# V-C7H=o޾fb)-ѳ#WWdįĪhuԃO_H[X_)Y0!#x_).'OPSh1(7fX:|~9 BGC 88^gUX3=Ԝj6PB_͘ktAA$
'tD
֩
Pqf9^J9vi&9uo(-ΡR \Ȯ^H7N5XM0V?w^OA
,iX$kwKWm.[y})v
c-[X]}tWpѶrR7T2yJP\Ux+4j!x+=hVmZT>2|FDZ-ffl!'wis/gS4َ6/u,Gq4J7n7՟)S_Σ5Eސ+rBg޸Ǵ~φ0_^Bo96ۭ_eUHf?\GY",m! E&RZܞ{(3lm L½{Qv[ÛApB5$lj$ NnN~[fL4Qy\:<L۠[J788Ǎb}e>IFEHzxՔjߖk"⷏PUjh~*S[} 鐐B$>yx0u@[XF?,FM+SGlշlr5˜{K=AHXN ?ZĖ.(9N܏ b(\lEXO
#ihLmːyRSc*fuK@::S_~AӔ*U&¦'dHpW1*66_`<lީ@5溳5TV%3<Pw:'IK;;CV^;!|m<=dJŎECۄ^1Q%Xnw'>8pTe_9/48^fPMSsW7mߑY