tor:PointYFromPosition(editor.CurrentPos)
	end
	xn = editor:PointXFromPosition(editor.CurrentPos)
	i = 0
	while x ~= xn and i < 50 do
		if xn < x then
			editor:CharRight()
		elseif xn > x then
			editor:CharLeft()
		end
		xn = editor:PointXFromPosition(editor.CurrentPos)
		i = i + 1
	end
end	-- ReplaceCharacters()

--------------------------------------------------------------------------------
-- ReplaceDocByPattern(sPat, fnPatMatch)
--
-- Replaces all occurences of a specific pattern by calling a user-defined
-- callback function.
--
-- Parameters:
-- sPat - The regular expresion pattern to match.
-- fnPatMatch - A callback function which will be called for each match.  The
--		captures from the pattern will be passed as arguments to the function.
--		Return the replacement string.
--------------------------------------------------------------------------------
function Common:ReplaceDocByPattern(sPat, fnPatMatch)
    local pos = editor.CurrentPos    -- Current position before modification
    local caret_line = editor:LineFromPosition(pos)    -- Line number to return to.
    local first_line = editor.FirstVisibleLine    -- The first visible line in the buffer
    local line_offset = 0    -- Number of lines inserted above the caret's original position
    local column = pos - editor:PositionFromLine(caret_line)    -- Convert back to beginning of line
    local old_line_count = editor.LineCount

    sPat = "()" .. sPat    -- Internal capture to record the position of each match.
    -- Local function which builds a string from the pattern matches.
    local function pat_match(p, ...)
        if pos > p then line_offset = line_offset + 1 end
        return fnPatMatch(...)
    end

    local sDoc = editor:GetText()
    -- We style the entire document so that match callbacks can use
    -- styling information to determine replacement data.
    editor:Colourise(0, -1)
    editor:SetText(sDoc:gsub(sPat, pat_match))

    local new_line_count = editor.LineCount

    if old_line_count > new_line_count then
        line_offset = line_offset * -1
    elseif old_line_count == new_line_count then
        line_offset = 0
    end

    pos = editor:PositionFromLine(caret_line +