 _Mode,
		int _Prot = (int)ios_base::_Openprot)
		{	// open a C stream with specified mode
		_Filet *_File;
		if (_Myfile != 0 || (_File = _Fiopen(_Filename, _Mode, _Prot)) == 0)
			return (0);	// open failed

		_Init(_File, _Openfl);
		_Initcvt((_Cvt *)&_USE(_Mysb::getloc(), _Cvt));
		return (this);	// open succeeded
		}

	_Myt *__CLR_OR_THIS_CALL open(const char *_Filename, ios_base::open_mode _Mode)
		{	// open a C stream with specified mode (old style)
		return (open(_Filename, (ios_base::openmode)_Mode));
		}

	_Myt *__CLR_OR_THIS_CALL open(const wchar_t *_Filename,
		ios_base::openmode _Mode,
		int _Prot = (int)ios_base::_Openprot)
		{	// open a wide-named C stream -- EXTENSION
		_Filet *_File;
		if (_Myfile != 0 || (_File = _Fiopen(_Filename, _Mode, _Prot)) == 0)
			return (0);	// open failed

		_Init(_File, _Openfl);
		_Initcvt((_Cvt *)&_USE(_Mysb::getloc(), _Cvt));
		return (this);	// open succeeded
		}

	_Myt *__CLR_OR_THIS_CALL open(const wchar_t *_Filename, ios_base::open_mode _Mode)
		{	// open a wide-named C stream (old style) -- EXTENSION
		return (open(_Filename, (ios_base::openmode)_Mode));
		}

#ifdef _NATIVE_WCHAR_T_DEFINED
	_Myt * __CLR_OR_THIS_CALL open(const unsigned short *_Filename,
		ios_base::openmode _Mode,
		int _Prot = (int)ios_base::_Openprot)
		{	// open a wide-named C stream -- EXTENSION
		_Filet *_File;
		if (_Myfile != 0 || (_File = _Fiopen(_Filename, _Mode, _Prot)) == 0)
			return (0);	// open failed

		_Init(_File, _Openfl);
		_Initcvt((_Cvt *)&_USE(_Mysb::getloc(), _Cvt));
		return (this);	// open succeeded
		}

	_Myt * __CLR_OR_THIS_CALL open(const unsigned short *_Filename, ios_base::open_mode _Mode)
		{	// open a wide-named C stream (old style) -- EXTENSION
		return (open(_Filename, (ios_base::openmode)_Mode));
		}
 #endif /* _NATIVE_WCHAR_T_DEFINED */

	_Myt *__CLR_OR_THIS_CALL close()
		{	// close the C stream
		_Myt *_Ans = this;
		if (_Myfile == 0)
			_Ans = 0;
		else
			{	// put any homing sequence and close file
			if (!_Endwrite())
				_Ans = 0;
			if (fclose(_Myfile) != 0)
				_Ans = 0;
			}
		_Init(0, _Closefl);
		return (_Ans);
		}

protected:
	virtual int_type __CLR_OR_THIS_CALL overflow(int_type _Meta = _Traits::eof())
		{	// put an element to stream
		if (_Traits::eq_int_type(_Traits::eof(), _Meta))
			return (_Traits::not_eof(_Meta));	// EOF, return success code
		else if (_Mysb::pptr() != 0
			&& _Mysb::pptr() < _Mysb::epptr())
			{	// room in buffer, store it
			*_Mysb::_Pninc() = _Traits::to_char_type(_Meta);
			return (_Meta);
			}
		else if (_Myfile == 0)
			return (_Traits::eof());	// no open C stream, fail
		else if (_Pcvt == 0)
			return (_Fputc(_Traits::to_char_type(_Meta), _Myfile)
				? _Meta : _Traits::eof());	// no codecvt facet, put as is
		else
			{	// put using codecvt facet
			const int _STRING_INC = 8;
			const _Elem _Ch = _Traits::to_char_type(_Meta);
			const _Elem *_Src;
			char *_Dest;

			string _Str(_STRING_INC, '\0');
			for (; ; )
				switch (_Pcvt->out(_State,
					&_Ch, &_Ch + 1, _Src,
					&*_Str.begin(), &*_Str.begin() + _Str.size(), _Dest))
				{	// test result of converting one element
				case codecvt_base::partial:
				case codecvt_base::ok:
					{	// converted something, try to put it out
					size_t _Count = _Dest - &*_Str.begin();
					if (0 < _Count && _Count !=
						fwrite(&*_Str.begin(), 1, _Count, _Myfile))
						return (_Traits::eof());	// write failed

					_Wrotesome = true;	// write succeeded
					if (_Src != &_Ch)
						return (_Meta);	// converted whole element

					if (0 < _Count)
						;
					else if (_Str.size() < 4 * _STRING_INC)
						_Str.append(_STRING_INC, '\0');	// try with more space
					else
						return (_Traits::eof());	// conversion failed
					break;
					}

				case codecvt_base::noconv:
					return (_Fputc(_Ch, _Myfile) ? _Meta
						: _Traits::eof());	// no conversion, put as is

				default:
					return (_Traits::eof());	// conversion failed
				}
			}
		}

	virtual int_type __CLR_OR_THIS_CALL pbackfail(int_type _Meta = _Traits::eof())
		{	// put an element back to stream
		if (_Mysb::gptr() != 0
			&& _Mysb::eback() < _Mysb::gptr()
			&& (_Traits::eq_int_type(_Traits::eof(), _Meta)
			|| _Traits::eq_int_type(_Traits::to_int_type(_Mysb::gptr()[-1]),
				_Meta)))
			{	// just back up position
			_Mysb::_Gndec();
			return (_Traits::not_eof(_Meta));
			}
		else if (_Myfile == 0 || _Traits::eq_int_type(_Traits::eof(), _Meta))
			return (_Traits::eof());	// no open C stream or EOF, fail
		else if (_Pcvt == 0 && _Ungetc(_Traits::to_char_type(_Meta), _Myfile))
			return (_Meta);	// no facet and unget succeeded, return
#pragma warning(push)
#pragma warning(disable: 6237 6239)
		/* prefast noise VSW 489858 */
		else if (1 < sizeof (_Elem) && _Mysb::gptr() != &_Mychar)
#pragma warning(pop)
			{	// putback to _Mychar
			_Mychar = _Traits::to_char_type(_Meta);
			_Mysb::setg(&_Mychar, &_Mychar, &_Mychar + 1);
			return (_Meta);
			}
		else
			return (_Traits::eof());	// nowhere to put back
		}

	virtual int_type __CLR_OR_THIS_CALL underflow()
		{	// get an element from stream, but don't point past it
		int_type _Meta;
		if (_Mysb::gptr() != 0
			&& _Mysb::gptr() < _Mysb::egptr())
			return (_Traits::to_int_type(*_Mysb::gptr()));	// return buffered
		else if (_Traits::eq_int_type(_Traits::eof(), _Meta = uflow()))
			return (_Meta);	// uflow failed, return EOF
		else
			{	// get a char, don't point past it
			pbackfail(_Meta);
			return (_Meta);
			}
		}

	virtual int_type __CLR_OR_THIS_CALL uflow()
		{	// get an element from stream, point past it
		if (_Mysb::gptr() != 0
			&& _Mysb::gptr() < _Mysb::egptr())
			return (_Traits::to_int_type(
				*_Mysb::_Gninc()));	// return buffered
		else if (_Myfile == 0)
			return (_Traits::eof());	// no open C stream, fail
		else if (_Pcvt == 0)
			{	// no codecvt facet, just get it
			_Elem _Ch;
			return (_Fgetc(_Ch, _Myfile) ? _Traits::to_int_type(_Ch)
				: _Traits::eof());
			}
		else
			{	// build string until codecvt succeeds
			string _Str;

			for (; ; )
				{	// get using codecvt facet
				_Elem _Ch, *_Dest;
				const char *_Src;
				ptrdiff_t _Nleft;
				int _Meta = fgetc(_Myfile);

				if (_Meta == EOF)
					return (_Traits::eof());	// partial char?

				_Str.append(1, (char)_Meta);	// append byte and convert
				switch (_Pcvt->in(_State,
					&*_Str.begin(), &*_Str.begin() + _Str.size(), _Src,
					&_Ch, &_Ch + 1, _Dest))
					{	// test result of converting one element
				case codecvt_base::partial:
				case codecvt_base::ok:
					if (_Dest != &_Ch)
						{	// got an element, put back excess and deliver it
						for (_Nleft = &*_Str.begin() + _Str.size() - _Src;
							0 < _Nleft; )
							ungetc(_Src[--_Nleft], _Myfile);
						return (_Traits::to_int_type(_Ch));
						}
					else
						_Str.erase((size_t)0,	// partial, discard used input
							(size_t)(_Src - &*_Str.begin()));
					break;

				case codecvt_base::noconv:
					if (_Str.size() < sizeof (_Elem))
						break;	// no conversion, but need more chars

					_CRT_SECURE_MEMCPY(&_Ch,sizeof (_Elem), &*_Str.begin(),
						sizeof (_Elem));	// copy raw bytes to element
					return (_Traits::to_int_type(_Ch));	// return result

				default:
					return (_Traits::eof());	// conversion failed
					}
				}
			}
		}

	virtual pos_type __CLR_OR_THIS_CALL seekoff(off_type _Off,
		ios_base::seekdir _Way,
		ios_base::openmode =
			(ios_base::openmode)(ios_base::in | ios_base::out))
		{	// change position by _Off
		fpos_t _Fileposition;

		if (_Mysb::gptr() == &_Mychar	// something putback
			&& _Way == ios_base::cur	// a relative seek
			&& _Pcvt == 0)	// not converting
			_Off -= (off_type)sizeof (_Elem);	// back up over _Elem bytes

		if (_Myfile == 0 || !_En