::_Init();	// reset any buffering
			}
		}

private:
	_Cvt *_Pcvt;	// pointer to codecvt facet (may be null)
	_Elem _Mychar;	// putback character, when _Ungetc fails
	bool _Wrotesome;	// true if homing sequence may be needed
	typename _Traits::state_type _State;	// current conversion state
	bool _Closef;	// true if C stream must be closed
	_Filet *_Myfile;	// pointer to C stream
	};


 #if defined(_DLL_CPPLIB) && !defined(_M_CEE_PURE)

template class _CRTIMP2_PURE basic_filebuf<char,
	char_traits<char> >;
template class _CRTIMP2_PURE basic_filebuf<wchar_t,
	char_traits<wchar_t> >;



 #endif /* _DLL_CPPLIB */

		// TEMPLATE CLASS basic_ifstream
template<class _Elem,
	class _Traits>
	class basic_ifstream
		: public basic_istream<_Elem, _Traits>
	{	// input stream associated with a C stream
public:
	typedef basic_ifstream<_Elem, _Traits> _Myt;
	typedef basic_filebuf<_Elem, _Traits> _Myfb;
	typedef basic_ios<_Elem, _Traits> _Myios;

	__CLR_OR_THIS_CALL basic_ifstream()
		: basic_istream<_Elem, _Traits>(&_Filebuffer)
		{	// construct unopened
		}

	explicit __CLR_OR_THIS_CALL basic_ifstream(const char *_Filename,
		ios_base::openmode _Mode = ios_base::in,
		int _Prot = (int)ios_base::_Openprot)
		: basic_istream<_Elem, _Traits>(&_Filebuffer)
		{	// construct with named file and specified mode
		if (_Filebuffer.open(_Filename, _Mode | ios_base::in, _Prot) == 0)
			_Myios::setstate(ios_base::failbit);
		}

	explicit __CLR_OR_THIS_CALL basic_ifstream(const wchar_t *_Filename,
		ios_base::openmode _Mode = ios_base::in,
		int _Prot = (int)ios_base::_Openprot)
		: basic_istream<_Elem, _Traits>(&_Filebuffer)
		{	// construct with wide-named file -- EXTENSION
		if (_Filebuffer.open(_Filename, _Mode | ios_base::in, _Prot) == 0)
			_Myios::setstate(ios_base::failbit);
		}

 #ifdef _NATIVE_WCHAR_T_DEFINED
	explicit __CLR_OR_THIS_CALL basic_ifstream(const unsigned short *_Filename,
		ios_base::openmode _Mode = ios_base::in,
		int _Prot = (int)ios_base::_Openprot)
		: basic_istream<_Elem, _Traits>(&_Filebuffer)
		{	// construct with wide-named file -- EXTENSION
		if (_Filebuffer.open(_Filename, _Mode | ios_base::in, _Prot) == 0)
			_Myios::setstate(ios_base::failbit);
		}
 #endif /* _NATIVE_WCHAR_T_DEFINED *