r.open(_Filename, _Mode | ios_base::in, _Prot) == 0)
			_Myios::setstate(ios_base::failbit);
		}

	void __CLR_OR_THIS_CALL open(const char *_Filename, ios_base::open_mode _Mode)
		{	// open named file with specified mode (old style)
		open(_Filename, (ios_base::openmode)_Mode);
		}

	void __CLR_OR_THIS_CALL close()
		{	// close the C stream
		if (_Filebuffer.close() == 0)
			_Myios::setstate(ios_base::failbit);
		}

private:
	_Myfb _Filebuffer;	// the file buffer
	};

 #if defined(_DLL_CPPLIB) && !defined(_M_CEE_PURE)

template class _CRTIMP2_PURE basic_ifstream<char,
	char_traits<char> >;
template class _CRTIMP2_PURE basic_ifstream<wchar_t,
	char_traits<wchar_t> >;



 #endif /* _DLL_CPPLIB */

		// TEMPLATE CLASS basic_ofstream
template<class _Elem,
	class _Traits>
	class basic_ofstream
		: public basic_ostream<_Elem, _Traits>
	{	// output stream associated with a C stream
public:
	typedef basic_ofstream<_Elem, _Traits> _Myt;
	typedef basic_filebuf<_Elem, _Traits> _Myfb;
	typedef basic_ios<_Elem, _Traits> _Myios;

	__CLR_OR_THIS_CALL basic_ofstream()
		: basic_ostream<_Elem, _Traits>(&_Filebuffer)
		{	// construct unopened
		}

	explicit __CLR_OR_THIS_CALL basic_ofstream(const char *_Filename,
		ios_base::openmode _Mode = ios_base::out,
		int _Prot = (int)ios_base::_Openprot)
		: basic_ostream<_Elem, _Traits>(&_Filebuffer)
		{	// construct with named file and specified mode
		if (_Filebuffer.open(_Filename, _Mode | ios_base::out, _Prot) == 0)
			_Myios::setstate(ios_base::failbit);
		}

	explicit __CLR_OR_THIS_CALL basic_ofstream(const wchar_t *_Filename,
		ios_base::openmode _Mode = ios_base::out,
		int _Prot = (int)ios_base::_Openprot)
		: basic_ostream<_Elem, _Traits>(&_Filebuffer)
		{	// construct with wide-named file -- EXTENSION
		if (_Filebuffer.open(_Filename, _Mode | ios_base::out, _Prot) == 0)
			_Myios::setstate(ios_base::failbit);
		}

 #ifdef _NATIVE_WCHAR_T_DEFINED
	explicit __CLR_OR_THIS_CALL basic_ofstream(const unsigned short *_Filename,
		ios_base::openmode _Mode = ios_base::out,
		int _Prot = (int)ios_base::_Openprot)
		: basic_ostream<_Elem, _Traits>(&_Filebuffer)
		{	// construct with wide-named file -- EXTENSION
		if (_Filebuffer.open(_Filename, _Mode | ios_base::out, _Prot) == 0)
			_Myios::setstate(ios_base::failbit);
		}
 #endif /* _NATIVE_WCHAR_T_DEFINED */

	explicit __CLR_OR_THIS_CALL basic_ofstream(_Filet *_File)
		: basic_ostream<_Elem, _Traits>(&_Filebuffer),
			_Filebuffer(_File)
		{	// construct with specified C stream
		}

	virtual __CLR_OR_THIS_CALL ~basic_ofstream()
		{	// destroy the object
		}

	_Myfb *__CLR_OR_THIS_CALL rdbuf() const
		{	// return pointer to file buffer
		return ((_Myfb *)&_Filebuffer);
		}

	bool __CLR_OR_THIS_CALL is_open() const
		{	// test if C stream has been opened
		return (_Filebuffer.is_open());
		}

	void __CLR_OR_THIS_CALL open(const wchar_t *_Filename,
		ios_base::openmode _Mode = ios_base::out,
		int _Prot = (int)ios_base::_Openprot)
		{	// open a wide-named C stream -- EXTENSION
		if (_Filebuffer.open(_Filename, _Mode | ios_base::out, _Prot) == 0)
			_Myios::setstate(ios_base::failbit);
		}

	void __CLR_OR_THIS_CALL open(const wchar_t *_Filename, ios_base::open_mode _Mode)
		{	// open a wide-named C stream (old style) -- EXTENSION
		open(_Filename, (ios_base::openmode)_Mode);
		}

 #ifdef _NATIVE_WCHAR_T_DEFINED
	void __CLR_OR_THIS_CALL open(const unsigned short *_Filename,
		ios_base::openmode _Mode = ios_base::out,
		int _Prot = (int)ios_base::_Openprot)
		{	// open a wide-named C stream -- EXTENSION
		if (_Filebuffer.open(_Filename, _Mode | ios_base::out, _Prot) == 0)
			_Myios::setstate(ios_base::failbit);
		}

	void __CLR_OR_THIS_CALL open(const unsigned short *_Filename, ios_base::open_mode _Mode)
		{	// open wide-named file (old style) -- EXTENSION
		open(_Filename, (ios_base::openmode)_Mode);
		}
 #endif /* _NATIVE_WCHAR_T_DEFINED */

	void __CLR_OR_THIS_CALL open(const char *_Filename,
		ios_base::openmode _Mode = ios_base::out,
		int _Prot = (int)ios_base::_Openprot)
		{	// open a C stream with specified mode
		if (_Filebuffer.open(_Filename, _Mode | ios_base::out, _Prot) == 0)
			_Myios::setstate(ios_base::failbit);
		}

	void __CLR_OR_THIS_CALL open(const char *_Filename, ios_base::open_mode _Mode)
		{	// open a C stream with specified mode (old style)
		open(_Filename, (ios_base::openmode)_Mode);
		}

	void __CLR_OR_THIS_CALL close()
		{	// close the C stream
		if (_Filebuffer.close() == 0)
			_Myios::setstate(ios_base::failbit);
		}

private:
	_Myfb _Filebuffer;	// the file buffer
	};

 #if defined(_DLL_CPPLIB) && !defined(_M_CEE_PURE)

template class _CRTIMP2_PURE basic_ofstream<char,
	char_traits<char> >;
template class _CRTIMP2_PURE basic_ofstream<wchar_t,
	char_traits<wchar_t> >;



 #endif /* _DLL_CPPLIB */

		// TEMPLATE CLASS basic_fstream
template<class _Elem,
	class _Traits>
	class basic_fstream
		: public basic_iostream<_Elem, _Traits>
	{	// input/output stream associated with a C stream
public:
	typedef basic_fstream<_Elem, _Traits> _Myt;
	typedef basic_ios<_Elem, _Traits> _Myios;
	typedef _Elem char_ty