E STRUCT logical_and
template<class _Ty>
	struct logical_and
		: public binary_function<_Ty, _Ty, bool>
	{	// functor for operator&&
	bool operator()(const _Ty& _Left, const _Ty& _Right) const
		{	// apply operator&& to operands
		return (_Left && _Right);
		}
	};

		// TEMPLATE STRUCT logical_or
template<class _Ty>
	struct logical_or
		: public binary_function<_Ty, _Ty, bool>
	{	// functor for operator||
	bool operator()(const _Ty& _Left, const _Ty& _Right) const
		{	// apply operator|| to operands
		return (_Left || _Right);
		}
	};

		// TEMPLATE STRUCT logical_not
template<class _Ty>
	struct logical_not
		: public unary_function<_Ty, bool>
	{	// functor for unary operator!
	bool operator()(const _Ty& _Left) const
		{	// apply operator! to operand
		return (!_Left);
		}
	};

		// TEMPLATE CLASS unary_negate
template<class _Fn1>
	class unary_negate
	: public unary_function<typename _Fn1::argument_type, bool>
	{	// functor adapter !_Func(left)
public:
	explicit unary_negate(const _Fn1& _Func)
		: _Functor(_Func)
		{	// construct from functor
		}

	bool operator()(const typename _Fn1::argument_type& _Left) const
		{	// apply functor to operand
		return (!_Functor(_Left));
		}

protected:
	_Fn1 _Functor;	// the functor to apply
	};

		// TEMPLATE FUNCTION not1
template<class _Fn1> inline
	unary_negate<_Fn1> not1(const _Fn1& _Func)
	{	// return a unary_negate functor adapter
	return (std::unary_negate<_Fn1>(_Func));
	}

		// TEMPLATE CLASS binary_negate
template<class _Fn2>
	class binary_negate
		: public binary_function<typename _Fn2::first_argument_type,
			typename _Fn2::second_argument_type, bool>
	{	// functor adapter !_Func(left, right)
public:
	explicit binary_negate(const _Fn2& _Func)
		: _Functor(_Func)
		{	// construct from functor
		}

	bool operator()(const typename _Fn2::first_argument_type& _Left,
		const typename _Fn2::second_argument_type& _Right) const
		{	// apply functor to operands
		return (!_Functor(_Left, _Right));
		}

protected:
	_Fn2 _Functor;	// the functor to apply
	};

		// TEMPLATE FUNCTION not2
template<class _Fn2> inline
	binary_negate<_Fn2> not2(const _Fn2& _Func)
	{	// return a binary_negate functor adapter
	return (std::binary_negate<_Fn2>(_Func));
	}

		// TEMPLATE CLASS binder1st
template<class _Fn2>
	class binder1st
		: public unary_function<typename _Fn2::second_argument_type,
			typename _Fn2::result_type>
	{	// functor adapter _Func(stored, right)
public:
	typedef unary_function<typename _Fn2::second_argument_type,
		typename _Fn2::result_type> _Base;
	typedef typename _Base::argument_type argument_type;
	typedef typename _Base::result_type result_type;

	binder1st(const _Fn2& _Func,
		const typename _Fn2::first_argument_type& _Left)
		: op(_Func), value(_Left)
		{	// construct from functor and left operand
		}

	result_type operator()