#ifndef _FILTERR_H_
#define _FILTERR_H_
#ifndef FACILITY_WINDOWS
//
//  Values are 32 bit values layed out as follows:
//
//   3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
//   1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
//  +---+-+-+-----------------------+-------------------------------+
//  |Sev|C|R|     Facility          |               Code            |
//  +---+-+-+-----------------------+-------------------------------+
//
//  where
//
//      Sev - is the severity code
//
//          00 - Success
//          01 - Informational
//          10 - Warning
//          11 - Error
//
//      C - is the Customer code flag
//
//      R - is a reserved bit
//
//      Facility - is the facility code
//
//      Code - is the facility's status code
//
//
// Define the facility codes
//
#define FACILITY_WINDOWS                 0x8
#define FACILITY_ITF                     0x4


//
// Define the severity codes
//
#define STATUS_SEVERITY_SUCCESS          0x0
#define STATUS_SEVERITY_COFAIL           0x3
#define STATUS_SEVERITY_COERROR          0x2


//
// MessageId: NOT_AN_ERROR
//
// MessageText:
//
//  NOTE:  This dummy error message is necessary to force MC to output
//         the above defines inside the FACILITY_WINDOWS guard instead
//         of leaving it empty.
//
#define NOT_AN_ERROR                     ((HRESULT)0x00080000L)

#endif // FACILITY_WINDOWS
//
// Codes 0x1700-0x172F are reserved for FILTER
//
//
// MessageId: FILTER_E_END_OF_CHUNKS
//
// MessageText:
//
//  No more chunks of text available in object.
//
#define FILTER_E_END_OF_CHUNKS           ((HRESULT)0x80041700L)

//
// MessageId: FILTER_E_NO_MORE_TEXT
//
// MessageText:
//
//  No more text available in chunk.
//
#define FILTER_E_NO_MORE_TEXT            ((HRESULT)0x80041701L)

//
// MessageId: FILTER_E_NO_MORE_VALUES
//
// MessageText:
//
//  No more property values available in chunk.
//
#define FILTER_E_NO_MORE_VALUES          ((HRESULT)0x80041702L)

//
// MessageId: FILTER_E_ACCESS
//
// MessageText:
//
//  Unable to access object.
//
#define FILTER_E_ACCESS                  ((HRESULT)0x80041703L)

//
// MessageId: FILTER_W_MONIKER_CLIPPED
//
// MessageText:
//
//  Moniker doesn't cover entire region.
//
#define FILTER_W_MONIKER_CLIPPED         ((HRESULT)0x00041704L)

//
// MessageId: FILTER_E_NO_TEXT
//
// MessageText:
//
//  No text in current chunk.
//
#define FILTER_E_NO_TEXT                 ((HRESULT)0x80041705L)

//
// MessageId: FILTER_E_NO_VALUES
//
// MessageText:
//
//  No values in current chunk.
//
#define FILTER_E_NO_VALUES               ((HRESULT)0x80041706L)

//
// MessageId: FILTER_E_EMBEDDING_UNAVAILABLE
//
// MessageText:
//
//  Unable to bind IFilter for embedded object.
//
#define FILTER_E_EMBEDDING_UNAVAILABLE   ((HRESULT)0x80041707L)

//
// MessageId: FILTER_E_LINK_UNAVAILABLE
//
// MessageText:
//
//  Unable to bind IFilter for linked object.
//
#define FILTER_E_LINK_UNAVAILABLE        ((HRESULT)0x80041708L)

//
// MessageId: FILTER_S_LAST_TEXT
//
// MessageText:
//
//  This is the last text in the current chunk.
//
#define FILTER_S_LAST_TEXT               ((HRESULT)0x00041709L)

//
// MessageId: FILTER_S_LAST_VALUES
//
// MessageText:
//
//  This is the last value in the current chunk.
//
#define FILTER_S_LAST_VALUES             ((HRESULT)0x0004170AL)

//
// MessageId: FILTER_E_PASSWORD
//
// MessageText:
//
//  File was not filtered due to password protection.
//
#define FILTER_E_PASSWORD                ((HRESULT)0x8004170BL)

//
// MessageId: FILTER_E_UNKNOWNFORMAT
//
// MessageText:
//
//  The document format is not recognized by the flter.
//
#define FILTER_E_UNKNOWNFORMAT           ((HRESULT)0x8004170CL)

#endif // _FILTERR_H_
                                                                                                                                                                                                               /*++

Copyright (c) 1990-1997,  Microsoft Corporation  All rights reserved.

Module Name:

    findtext.dlg

Abstract:

    This module contains the resource descriptions for the Win32
    find and replace common dialogs.

Revision History:

--*/



//
//  Find and Replace Dialogs.
//

FINDDLGORD DIALOG LOADONCALL MOVEABLE DISCARDABLE 30, 73, 236, 62
STYLE WS_BORDER | WS_CAPTION | DS_MODALFRAME | WS_POPUP | WS_SYSMENU |
      DS_3DLOOK | DS_CONTEXTHELP
CAPTION "Find"
FONT 8, "MS Shell Dlg"
BEGIN
    LTEXT           "Fi&nd what:", -1, 4, 8, 42, 8
    EDITTEXT        edt1, 47, 7, 128, 12, WS_GROUP | WS_TABSTOP | ES_AUTOHSCROLL

    AUTOCHECKBOX    "Match &whole word only", chx1, 4, 26, 100, 12, WS_GROUP
    AUTOCHECKBOX    "Match &case", chx2, 4, 42, 64, 12

    GROUPBOX        "Direction", grp1, 107, 26, 68, 28, WS_GROUP
    AUTORADIOBUTTON "&Up", rad1, 111, 38, 25, 12, WS_GROUP
    AUTORADIOBUTTON "&Down", rad2, 138, 38, 3