/* fmi.h */
/*
 * (C) Copyright Data Connection Limited 1989-1992.
 * (C) Copyright Microsoft Corporation 1991.
 * All Rights Reserved.
 */

#ifndef FMIH_INCLUDED
#define FMIH_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#ifdef WIN32_SUPPORT
  #pragma pack(1)
#endif

/*****************************************************************************/
/* The following type definitions are in os2def.h so are not needed in OS/2  */
/*****************************************************************************/
#if (defined(DOS_SUPPORT) || defined(MSWIN_SUPPORT))
#define CHAR          char      /* ch  */
typedef unsigned char UCHAR;    /* uch */
typedef unsigned short USHORT;  /* us  */
typedef unsigned long ULONG;    /* ul  */
#endif

/*****************************************************************************/
/* Type definitions for message fields                                       */
/*****************************************************************************/
typedef signed short         INTEGER;

/*****************************************************************************/
/* Macro to convert integer fields other than STARTD and ENDD, SRCI          */
/* and DESTI to In-line format                                               */
/*****************************************************************************/
#ifndef WIN32_SUPPORT
#define DOFLIP(X) ((INTEGER)((((X) & 0xff) << 8) | (((X) >> 8) & 0xff)))
#else
#ifndef ROTL
 #ifndef _CRTAPI1
  unsigned int _rotl(unsigned int, int);
 #else
  unsigned int _CRTAPI1 _rotl(unsigned int, int);
 #endif
  #define ROTL
#endif
#pragma intrinsic(_rotl)
#define DOFLIP(X)   ((INTEGER)_rotl(((unsigned short)(X))*(unsigned long)0x00010001, 8))
#endif
#define DONTFLIP(X) (X)


#ifdef NON_INTEL_BYTE_ORDER
 #define PFLIPI(X)      DONTFLIP(X)
 #define PANTIFLIPI(X)  DOFLIP(X)
#else
 #define PFLIPI(X)      DOFLIP(X)
 #define PANTIFLIPI(X)  DONTFLIP(X)
#endif


/*****************************************************************************/
/* Element offset and length definitions                                     */
/*****************************************************************************/

#define SBCBELT1 1
#define SBCBELT3 13
#define SNANBEDA 268     /* LENGTH OF BUFFER ELEMENT */

/*****************************************************************************/
/* MESSAGE TYPE DECLARATIONS - ELEMENT OPTIONS                               */
/*****************************************************************************/
     typedef
#define RHASENSE     0
#define DATAONLY     1
     signed char ELTDATAT;

     typedef CHAR     SNCHARRU[SNANBEDA];        /* LENGTH OF ELT */

/*****************************************************************************/
/* MAIN DEFINITION OF MESSAGE EL