*****/
/* BIND Table Index Values for the Open PLU response (in element)            */
/*****************************************************************************/

#define BIND_TABLE_INDEX_PRT    1
#define BIND_TABLE_INDEX_CRT    2

/*****************************************************************************/
/* CLOSE MESSAGE TYPE DECLARATIONS                                           */
/*****************************************************************************/

     typedef struct tpclhdr{                         /* CLOSE MESSAGE HEADER */
                      CHAR     closqual;    /* Same values as openqual       */
                      CHAR     clstype;     /* Same values as opentype       */
                      CHAR     clsctl;      /* For Close(PLU) only           */
#define CLNORMAL 1
#define CLBIND   2
#define CLCFAERR 3
#define CLPUINAC 4
#define CLLUINAC 5
#define CLLNKERR 6
#define CLBFSHRT 7
#define CLRCVCHK 8
#define CLSLUTRM 9
                      CHAR     clspad1;
                      INTEGER  clspad2;
                      INTEGER  clserr1;
                      INTEGER  clserr2;
                    }TPCLHDR;

/*****************************************************************************/
/* STATUS-ACKNOWLEDGE MESSAGE TYPE DECLARATION                               */
/*****************************************************************************/

     typedef struct tpstahdr{                   /* STATUS ACK MESSAGE HEADER */
                      CHAR     akstat;
#define ACK      1
                      CHAR     akqual;
#define ACKPOS   2
#define ACKNEG1  3
#define ACKNEG2  4
                      INTEGER  akmsgkey;
                      union {
                              INTEGER XXXXX01;
                              struct {
                                 CHAR     XXXXX02;
                                 CHAR     XXX