/****************************************************************************** 
/* Module: Example
/* Description: Shows how to generate Trial Extension keys in C# language
/*
/* Authors: Rafael Ahucha  
/* (c) 2004 Winlicense Professional
/*****************************************************************************/ 


/****************************************************************************** 
/*                   Libraries used by this module
/*****************************************************************************/ 

using System;
using System.Reflection;
using System.Windows.Forms;
using System.IO;
using System.Collections;
using System.Text;
using System.Runtime.InteropServices;
using System.Security;
using Microsoft.Win32;


/****************************************************************************** 
/* Class: App
/*
/* Description: Main application class
/*
/******************************************************************************/

class App{
    
   public static void Main(string[] args){

        string TrialHash = "dsf7987fgvb87vc89n32d6z4c8b9s6a5d8g623n334jgt1i23324gvfa2334jc87634h";
        byte[] ExtendedKey = new byte [100];
        int    SizeKey;

        // Create a key extending days to 3 and executions to 5
        
        SizeKey = WinlicenseSDK.WLGenTrialExtensionFileKey(TrialHash,0,3,5,0,0,0, ExtendedKey);

        // Create file to store the generated key

        FileStream fs = new FileStream("extendkey.dat", FileMode.Create);
        
        BinaryWriter w = new BinaryWriter(fs);
        
        // Write data to file

        for (int i = 0; i < SizeKey; i++)
        {
            w.Write((byte)ExtendedKey[i]);
        }

        // Close file
        
        w.Close();
        fs.Close();

        MessageBox.Show("A trial extension key has been generated", "Trial Extension SDK");
        
}


    /****************************************************************************** 
    /* Class: WinlicenseSDK
    /*
    /* Description: Wrapper for the Winlicense SDK APIs
    /*
    /******************************************************************************/

    class WinlicenseSDK
    {
        [DllImport( "WinlicenseSDK.dll", EntryPoint="WLGenTrialExtensionFileKey", CallingConvention = CallingConvention.StdCall )]
        public static extern int WLGenTrialExtensionFileKey(string TrialHash, int Level, int NumDays, int NumExec, int NewDate, int NumMinutes, int TimeRuntime, byte[] BufferOut);
    }
    
}
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            BBBBBVHPTTAۘVMXK\DUMAAgATA{/VMCV{@
_{/7l+!{/ {2qP76({/ {2/ ~VԪ|/|V!<; ;!{/q!2VB	V	V?SIHOHO"OODO'H_IHrIHgH7H?H$HHH"HBVVVwVVVX_TXNX@{/B	VX_TXNX@2VZIX_TX@~O"	VVVVoVHOHO"OODO'H_IHrIHgH7H?H$HHH"HBVVVwVrVr
VOLX_TXN@VLX_TXN@"	VG	VX_TX@OLMCOXTIQWTVXTAPQTX_Q@]T@XJTXTXX_XTX@{/VX_@]T@XJTXX_X@X_CTXXQQH{/V?VVVV?SIHOHO"OODOV_IH[FileVersion]
Version=7.0
[Compiler]
A=8
B=0
C=1
D=1
E=0
F=0
G=1
H=1
I=1
J=0
K=0
L=1
M=0
N=1
O=1
P=1
Q=0
R=0
S=0
T=0
U=0
V=1
W=0
X=1
Y=1
Z=1
ShowHints=1
ShowWarnings=1
UnitAliases=WinTypes=Windows;WinProcs=Windows;DbiTypes=BDE;DbiProcs=BDE;DbiErrs=BDE;
NamespacePrefix=
SymbolDeprecated=1
SymbolLibrary=1
SymbolPlatform=1
UnitLibrary=1
UnitPlatform=1
UnitDeprecated=1
HResultCompat=1
HidingMember=1
HiddenVirtual=1
Garbage=1
BoundsError=1
ZeroNilCompat=1
StringConstTruncated=1
ForLoopVarVarPar=1
TypedConstVarPar=1
AsgToTypedConst=1
CaseLabelRange=1
ForVariable=1
ConstructingAbstract=1
ComparisonFalse=1
ComparisonTrue=1
ComparingSignedUnsigned=1
CombiningSignedUnsigned=1
UnsupportedConstruct=1
FileOpen=1
FileOpenUnitSrc=1
BadGlobalSymbol=1
DuplicateConstructorDestructor=1
InvalidDirective=1
PackageNoLink=1
PackageThreadVar=1
ImplicitImport=1
HPPEMITIgnored=1
NoRetVal=1
UseBeforeDef=1
ForLoopVarUndef=1
UnitNameMismatch=1
NoCFGFileFound=1
MessageDirective=1
ImplicitVariants=1
UnicodeToLocale=1
LocaleToUnicode=1
ImagebaseMultiple=1
SuspiciousTypecast=1
PrivatePropAccessor=1
UnsafeType=0
UnsafeCode=0
UnsafeCast=0
[Linker]
MapFile=0
OutputObjs=0
ConsoleApp=1
DebugInfo=0
RemoteSymbols=0
MinStackSize=16384
MaxStackSize=1048576
ImageBase=4194304
ExeDescription=
[Directories]
OutputDir=
UnitOutputDir=
PackageDLLOutputDir=
PackageDCPOutputDir=
SearchPath=
Packages=
Conditionals=
DebugSourceDirs=
UsePackages=0
[Parameters]
RunParams=
HostApplication=
Launcher=
UseLauncher=0
DebugCWD=
[Language]
ActiveLang=
ProjectLang=
RootDir=
[Version Info]
IncludeVerInfo=0
AutoIncBuild=0
MajorVer=1
MinorVer=0
Release=0
Build=0
Debug=0
PreRelease=0
Special=0
Private=0
DLL=0
Locale=3082
CodePage=1252
[Version Info Keys]
CompanyName=
FileDescription=
FileVersion=1.0.0.0
InternalName=
LegalCopyright=
LegalTrademarks=
OriginalFilename=
ProductName=
ProductVersion=1.0.0.0
Comments=
                                 7{ ?{N{@2{O{@{{CpRM~ {!7t-{N~@tV74< { ~N{@7K%{N{{@{ACP%~N{@{{Ni?\I7^%|@{@7H %teݼ{@{{@{{CpS~N"{{@{{ "{@7%ACP4{@7=%{@76%{'\q~@775 {@7*%{@776 {@{O7s6 7Q`%{@{{ 7{@7%{@7|%;{@7^%~ '{@{	{ '{@7%{@7%{N{ {@{/|V{@7 {@7 {@27
 !< ;?/|TV~@'70 !<s ;;
{0!B {2	LPuN
{|  
VԪ|| |  
VԪ|{GiE7 "|@{!7%7" |@{!7{%{',~@700 {!7]%{'{ {!7h%{!7%{@7< {{@7a%;~@2{{@7K< W
VP2W
V~@77<5 {@7~ ?{!7ay-{N?~@4t
V75 {@4~ {@7G{ {@{q-A{@74= Sv;~ {!7y-{N~@t
V75 {@~ {@7{ {@{
GA~ '{!7y-{N'~@"t
V7= {@"~ ${@7+{ ${@7U&"t/P/|M
V{@7&+ {@7 !< ;7/|
V~@$7$1 !< ;;
{0!B {2	LPuN
|N{{{@75 / VԪ|/|@/|@/ טVԪ|i$]I7~ |@{ {@{	{KiE7!"|@{@{Gp/RO|@V~N7{{@{P7V~@27= {@2~ ?{!7.Z-{N?~@4V7y0 {@4~ {-7Q{ {@{ANP{@{{;~ {!7uZ-{N~@V70 {@~ {-7{ {@{GA~ '{!7Z-{N'~@"V70 {@"~ ${-7{ ${@7d'"t/P/|לV{@7 {@7z !<< ;7/|AV~@$79 ~@7 9 !< ;1
{0!BGK@
ABI@
JJGK@
A @C
 @GK@
BJAIB
NIAGLC@GK@
 @GK@
@MJNICA@
DIIGK@
A @C
AJCMLEGK@
DC
DII/74%!~O/7Ā%!~O {2	
tTq$7| {w {{#{!7$%~qw7r? -Ai$ V72 {|{{%7{!^T7 zq${!
!
7p {{MP{-7{}7, {8{-70!%tS{-7H !~O
{M!{-7%%MPtT{-7!{/
{{Q{-{u@77 t/T{-{u@7: !/!~O{{A{u@7 t/TQ{!7{Ͽ|{ϴ|t|Ǵ%V{|_{t|T|t%/V{/                                        
        (       @                                                                 1        33331        3333         33333                     33331 DD        FvvD      1 Gggfv@     1&vvggd     1wwgbvt     1wwwr"gf@    1wwwr"vv@     3wr""gf@     3wr""&f@     ww"w""@     1wr'""@     1w""$      1rwr"       3'w"/       3"ww$       ""       1            1          3  p     31    3333;31     333333    3333                                   ? ?              ?  ?  ?  ~>  ?  ?  ?  ?  ?  ?   0    M A I N I C O N         
                                                                                                                                                                        nt="1"
				TypeLibraryName=".\Release/keygen.tlb"
				HeaderFileName=""
			/>
			<Tool
				Name="VCCLCompilerTool"
				Optimization="2"
				InlineFunctionExpansion="1"
				PreprocessorDefinitions="WIN32;NDEBUG;_WINDOWS"
				StringPooling="true"
				RuntimeLibrary="2"
				EnableFunctionLevelLin