/*++

Copyright (c) 1995-1997 Microsoft Corporation

Module Name:

    stm.h

Abstract:

    This module contains the definitions of the IPX Service Table Manger APIs

Author:


Revision History:


--*/

#ifndef __ROUTING_STM_H__
#define __ROUTING_STM_H__

//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// Supported functionality flags                                            //
//                                                                          //
// ROUTING                  Imports Routing Table Manager APIs              //
// SERVICES                 Exports Service Table Manager APIs              //
// DEMAND_UPDATE_ROUTES     IP and IPX RIP support for Autostatic           //
// DEMAND_UPDATE_SERVICES   IPX SAP, NLSP support for Autostatic            //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#define SERVICES                0x00000002
#define DEMAND_UPDATE_SERVICES  0x00000008

//
// Server Entry 
//

typedef struct _IPX_SERVER_ENTRY
{
    USHORT	Type;
    UCHAR	Name[48];
    UCHAR	Network[4];
    UCHAR	Node[6];
    UCHAR	Socket[2];
    USHORT	HopCount;
} IPX_SERVER_ENTRY, *PIPX_SERVER_ENTRY;

typedef struct _IPX_SERVICE
{
    ULONG		        InterfaceIndex;
    ULONG	            Protocol;	// protocol from which knowledge of the service was obatined
    IPX_SERVER_ENTRY	Server;
} IPX_SERVICE, *PIPX_SERVICE;

// Function which returns TRUE if the service exists

typedef
BOOL
(WINAPI * PIS_SERVICE)(
      IN USHORT 	Type,
      IN PUCHAR 	Name,
      OUT PIPX_SERVICE	Service OPTIONAL
      );

// Exclusion flags.  Limit enumeration to only servers that
// have same values of the specified by flags parameter(s) as those of
// criterea service.

#define STM_ONLY_THIS_INTERFACE     0x00000001
#define STM_ONLY_THIS_PROTOCOL	    0x00000002
#define STM_ONLY_THIS_TYPE	        0x00000004
#define STM_ONLY_THIS_NAME	        0x00000008

// Ordering methods. Specify the order in which