SERVER_ENTRY		ServerEntry);

//	Delete service of IPX_PROTOCOL_STATIC from the table

typedef
DWORD
(WINAPI * PDELETE_STATIC_SERVICE)(IN ULONG		InterfaceIndex,
		       IN PIPX_SERVER_ENTRY		ServerEntry);


//	Converts protocol of all services associated with given interface to
//	IPX_PROTOCOL_STATIC

typedef
DWORD
(WINAPI * PBLOCK_CONVERT_SERVICES_TO_STATIC) (
	IN ULONG		InterfaceIndex
	);

//	Delete all services of IPX_PROTOCOL_STATIC
//	associated with  given interface from the table

typedef
DWORD
(WINAPI * PBLOCK_DELETE_STATIC_SERVICES)(
	IN ULONG		InterfaceIndex
	);


// Find and return first service in the order specified by the ordering method.
// Search is limited only to ceratin types of services as specified by the
// exclusion flags end corresponding fields in Service parameter.
// Returns ERROR_NO_MORE_ITEMS if there are no services in the
// table that meet specified criteria.

typedef
DWORD
(WINAPI * PGET_FIRST_ORDERED_SERVICE)(
    IN  DWORD           OrderingMethod,     // What ordering to use
    IN  DWORD           ExclusionFlags,     // Flags to limit search to ceratin
                                            // types of servers
    IN OUT PIPX_SERVICE Service 	    // On input: criteria for exclusion
                                            //          flags
                                            // On output: first service entry
                                            //          in the specified order
    );

// Find and return next service in the order specified by the ordering method.
// Search starts from specified service and is limited only to ceratin types
// of services as specified by the exclusion flags and corresponding fields 
// in Service parameter.
// Returns ERROR_NO_MORE_ITEMS if there are no services in table
// table that meet specified criteria.

typedef
DWORD
(WINAPI * PGET_NEXT_ORDERED_SERVICE)(
    IN  DWORD           OrderingMethod,     // What ordering to use
    IN  DWORD           ExclusionFlags,     // Flags to limit search to ceratin
                                            // types of servers
    IN OUT PIPX_SERVICE Service 	    // On input: service to start the
 