/***********************************************************************
**      	S T R E A M T Y . H                                        *
**                                                                     *
************************************************************************
** Copyright (C) 1996 by Microsoft Corporation                         *
**                 All Rights Reserved                                 *
************************************************************************/
/*
        STREAMTY.H

        StreamType record object class definitions for Microsoft Guide
*/


#ifndef _STREAMTY_H_
#define _STREAMTY_H_


#include "dbsets.h"


/*

StreamType objects are constructed from database records of the StreamType table.

The CStreamTypeRecordset class is used to select and create CStreamType objects
from the StreamType table via functions in the CDatabaseRecordset parent class.

*/


class COMMMSTVEXPORT CStreamTypeRecordset : public CDatabaseRecordset
{

// This class provides StreamType recordset manipulation via parent functions


virtual CString GetTableName( VOID);

virtual BOOL    SetRecordsetObject( VOID* cRecordsetObject);

public:
virtual VOID*   GetRecordsetObject( VOID);
virtual BOOLEAN Seek(LPCTSTR lpszComparison, CObject &coo);
virtual BOOLEAN Seek(LPCTSTR lpszComparison, LONG lStreamTypeID);
};


class COMMMSTVEXPORT CStreamType : public CObject
{

    friend class CStreamTypeRecordset; // generates the CStreamType record object

private:

    LONG		m_lStreamTypeID;
    LONG		m_lTuningSpace;
    LONG		m_lValue;
    CString		m_cszDescription;
    LONG		m_lCategory;
    LONG		m_lLocaleID;

public:

	CStreamType(LONG lStreamTypeID = AFX_RFX_LONG_PSEUDO_NULL,
				LONG lTuningSpace = 0,
				LONG lValue = 0,
				CString cszDescription = "",
				LONG lCategory = 0,
				LONG lLocaleID = 0) :
				m_