
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/war.zip" ),
}
local prefabs = {}

local start_inv =
{
    "cane",
}

local fn = function(inst)
	
	-- choose which sounds this character will play
	inst.soundsname = "maxwell"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon( "Warnie.tex" )

	-- todo: Add an example special power here.
	inst.components.health:SetMaxHealth(80)
inst.components.health.canheal = true
inst.components.health.fire_damage_scale = 1
inst.components.sanity.max = 100
inst.components.sanity.night_drain_mult = 0.9
inst.components.sanity.neg_aura_mult = 0.9
inst.components.hunger.max = 111
inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1)
inst.components.eater.strongstomach = false
inst.components.eater.ignoresspoilage = false
inst.components.combat.damagemultiplier = 0.9
inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 0.9)
inst.components.locomotor.enablegroundspeedmultiplier = true
inst.components.talker.colour = Vector3( .8, 0, 1, 0)
end


STRINGS.CHARACTERS.AVA = require "speech_war"
return MakePlayerCharacter("war", prefabs, assets, fn, start_inv)
