local assets =
{
	Asset( "ANIM", "anim/waxwell.zip" ),
	Asset( "ANIM", "anim/ghost_waxwell_build.zip" ),
	
    Asset("ATLAS", "images/inventoryimages/waxwell_switch.xml"),
    Asset("IMAGE", "images/inventoryimages/waxwell_switch.tex"),
}

local function onbuilt(inst, builder)
	-- builder:MakeWillow()
	SetSkinMode(builder.AnimState, "waxwell", "waxwell", builder.components.skinner:GetClothing(), nil, "waxwell")
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	inst:AddTag("CLASSIFIED")

	inst.persists = false

	inst:DoTaskInTime(0, inst.Remove)

	if not TheWorld.ismastersim then
		return inst
	end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "waxwell_switch"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/waxwell_switch.xml"

	inst.OnBuiltFn = onbuilt

	return inst
end

return Prefab("waxwell_switch", fn, assets)