local assets =
{
	Asset( "ANIM", "anim/webber.zip" ),
	Asset( "ANIM", "anim/ghost_webber_build.zip" ),
	
    Asset("ATLAS", "images/inventoryimages/webber_switch.xml"),
    Asset("IMAGE", "images/inventoryimages/webber_switch.tex"),
}

local function onbuilt(inst, builder)
	-- builder:MakeWillow()
	SetSkinMode(builder.AnimState, "webber", "webber", builder.components.skinner:GetClothing(), nil, "webber")
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	inst:AddTag("CLASSIFIED")

	inst.persists = false

	inst:DoTaskInTime(0, inst.Remove)

	if not TheWorld.ismastersim then
		return inst
	end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "webber_switch"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/webber_switch.xml"

	inst.OnBuiltFn = onbuilt

	return inst
end

return Prefab("webber_switch", fn, assets)