local assets =
{
	Asset( "ANIM", "anim/willow.zip" ),
	Asset( "ANIM", "anim/ghost_willow_build.zip" ),
	
    Asset("ATLAS", "images/inventoryimages/willow_switch.xml"),
    Asset("IMAGE", "images/inventoryimages/willow_switch.tex"),
}

local function onbuilt(inst, builder)
	-- builder:MakeWillow()
	SetSkinMode(builder.AnimState, "willow", "willow", builder.components.skinner:GetClothing(), nil, "willow")
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	inst:AddTag("CLASSIFIED")

	inst.persists = false

	inst:DoTaskInTime(0, inst.Remove)

	if not TheWorld.ismastersim then
		return inst
	end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "willow_switch"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/willow_switch.xml"

	inst.OnBuiltFn = onbuilt

	return inst
end

return Prefab("willow_switch", fn, assets)