local assets =
{
	Asset( "ANIM", "anim/wilson.zip" ),
	Asset( "ANIM", "anim/ghost_wilson_build.zip" ),
	
    Asset("ATLAS", "images/inventoryimages/wilson_switch.xml"),
    Asset("IMAGE", "images/inventoryimages/wilson_switch.tex"),
}

local function onbuilt(inst, builder)
	-- builder:MakeWillow()
	SetSkinMode(builder.AnimState, "wilson", "wilson", builder.components.skinner:GetClothing(), nil, "wilson")
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	inst:AddTag("CLASSIFIED")

	inst.persists = false

	inst:DoTaskInTime(0, inst.Remove)

	if not TheWorld.ismastersim then
		return inst
	end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wilson_switch"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wilson_switch.xml"

	inst.OnBuiltFn = onbuilt

	return inst
end

return Prefab("wilson_switch", fn, assets)