local assets =
{
	Asset( "ANIM", "anim/wolfgang.zip" ),
	Asset( "ANIM", "anim/ghost_wolfgang_build.zip" ),
	
    Asset("ATLAS", "images/inventoryimages/wolfgang_switch.xml"),
    Asset("IMAGE", "images/inventoryimages/wolfgang_switch.tex"),
}

local function onbuilt(inst, builder)
	-- builder:MakeWillow()
	SetSkinMode(builder.AnimState, "wolfgang", "wolfgang", builder.components.skinner:GetClothing(), nil, "wolfgang")
	inst:Remove()
end

local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()

	inst:AddTag("CLASSIFIED")

	inst.persists = false

	inst:DoTaskInTime(0, inst.Remove)

	if not TheWorld.ismastersim then
		return inst
	end
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "wolfgang_switch"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/wolfgang_switch.xml"

	inst.OnBuiltFn = onbuilt

	return inst
end

return Prefab("wolfgang_switch", fn, assets)