function OnMsg.GameTimeStart()
    AutoDemolishConcreteExtractorInstallThread()
end

function OnMsg.LoadGame()
    AutoDemolishConcreteExtractorInstallThread()
end

-- Install the game time thread that periodically evaluates rovers
function AutoDemolishConcreteExtractorInstallThread()
    CreateGameTimeThread(function()
        while true do
            Sleep(300)
            AutoDemolishConcreteExtractorHandler() 
        end
    end)
end

-- Evaluates all Concrete Extractors, issues commands to dismantle them
function AutoDemolishConcreteExtractorHandler()
    -- notification settings
    local showNotifications = AutoDemolishConcreteExtractorShowNotification();

    -- behavior settings
    local enabledAction = AutoDemolishConcreteExtractorEnabledAction();

    -- if this feature is not turned off via mod
    if enabledAction ~= "off" then
        -- It's called regolith extractor
        ForEach { class = "RegolithExtractor", 
            -- ignore those that are being constructed
            filter = function(o)
                return not IsKindOf(o, "ConstructionSite")
            end,
            -- execute for each fund extractor
            exec = function(extractor)
                -- Check if the available amount is zero
                if extractor:GetAmount() == 0 then
                    -- extractor.demolishing gets nil'd when the demolish action completes
                    -- enabledAction can be "salvage" or "all" at this point
                    if (not extractor.destroyed) and (not extractor.demolishing) and (not extractor:IsDemolishing()) then
                        -- display the salvage notification if allowed
                        if showNotifications == "all" then
                            AddCustomOnScreenNotification("AutoDemolishConcreteExtractorSalvage", 
                                T{"混凝土挖掘站"}, 
                                T{"正在拆除已枯竭的混凝土挖掘站"}, 
                                "UI/Icons/Notifications/deposit_depleted.tga",
                                false, { expiration = 15000 }
                            )
                        end
                        -- enable
                        extractor:ToggleDemolish()
                    end

                    if enabledAction == "all" then
                        -- if destroyed but not yet bulldozed and the research is there
                        if (extractor.destroyed) and (not extractor.bulldozed) 
                                and UICity:IsTechResearched("DecommissionProtocol") then
                            -- display the salvage notification if allowed
                            if showNotifications == "all" then
                                AddCustomOnScreenNotification("AutoDemolishConcreteExtractorDecomission", 
                                    T{"混凝土挖掘站"}, 
                                    T{"正在清理已枯竭的混凝土挖掘站"}, 
                                    "UI/Icons/Notifications/deposit_depleted.tga",
                                    false, { expiration = 15000 }
                                )
                            end
                            -- DestroyedClear(true) would be clearing all that have state destoyed, even damaged ones
                            extractor:DestroyedClear(false)
                        end
                    end
                end
        end }
    end
end

-- See if ModConfig is installed and that notifications are enabled
function AutoDemolishConcreteExtractorShowNotification()
    if rawget(_G, "ModConfig") then
        return ModConfig:Get("AutoDemolishConcreteExtractor", "Notifications")
    end
    return "all"
end

-- See if ModConfig is installed operations are enabled
function AutoDemolishConcreteExtractorEnabledAction()
    if rawget(_G, "ModConfig") then
        return ModConfig:Get("AutoDemolishConcreteExtractor", "Action")
    end
    return "all"
end

-- ModConfig signals "ModConfigReady" when it can be manipulated
function OnMsg.ModConfigReady()

    -- Register the mod
    ModConfig:RegisterMod("AutoDemolishConcreteExtractor",
        T{"自动拆除混凝土挖掘站"},
        T{"自动拆除和清理已枯竭的混凝土挖掘器"}
    ) 

    -- Register the notification settings
    ModConfig:RegisterOption("AutoDemolishConcreteExtractor", "Notifications", {
        name = T{"通知"},
        desc = T{"开启/关闭混凝土挖掘站自动拆卸通知."},
        type = "enum",
        values = {
            {value = "all", label = T{"全部"}},
            -- Not applicable here
            -- {value = "problems", label = T{"仅问题"}},
            {value = "off", label = T{"关闭"}}
        },
        default = "all" 
    })

    -- Register the action to take
    ModConfig:RegisterOption("AutoDemolishConcreteExtractor", "Action", {
        name = T{"行动"},
        desc = T{"当混凝土挖掘器枯竭时采取何种行动,注意:清除废墟需要研究'退役协定(工程学)'"},
        type = "enum",
        values = {
            {value = "all", label = T{"拆除 & 清理"}},
            {value = "salvage", label = T{"只拆除"}},
            {value = "off", label = T{"什么都不做"}}
        },
        default = "all" 
    })

end