local assets=
{
	Asset("ANIM", "anim/hat_warhat.zip"),
  Asset("ATLAS", "images/inventoryimages/hat_warhat.xml")
}

local function onequip(inst, owner) 
        owner.AnimState:OverrideSymbol("swap_hat", "hat_warhat", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
end

local function onunequip(inst, owner) 
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
end

	
local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    inst:AddTag("hat")
    
    anim:SetBank("winterhat")
    anim:SetBuild("hat_warhat")
    anim:PlayAnimation("anim")    
        
    inst:AddComponent("inspectable")
    
    inst:AddTag("irreplaceable")
	
    inst:AddComponent("insulator")
	inst.components.insulator.insulation = TUNING.INSULATION_SMALL	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_warhat.xml"
    
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end

return Prefab( "common/inventory/hat_warhat", fn, assets ) 