local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/warios.zip" ),
}
local prefabs = 
{

}	
local start_inv =
{
    "hat_warhat",
}
local fn = function(inst)
	--speech sound and map icon
	inst.soundsname = "warios"
	inst.MiniMapEntity:SetIcon( "wolfgang.png" )
	--Stats
	inst.components.health:SetMaxHealth(280)
	inst.components.hunger:SetMax(450)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 2)
	inst.components.sanity:SetMax(110)
	inst.components.combat.damagemultiplier = 3
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.1)
    inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.1)
	--Sanity FX
	inst.components.sanity.night_drain_mult = TUNING.WENDY_SANITY_MULT * 1.8
	inst.components.sanity.neg_aura_mult = 0.6
	--Freezing
	inst.components.temperature:SetTemp( 50 )
    local Temperature = Class(function(self, inst)
    self.inherentinsulation = 50
    end)
	--Attacking ranges
	local Combat = Class(function(self, inst)
	inst.components.combat.attackrange = 6
	inst.components.combat.hitrange = 4
	inst.components.combat.min_attack_period = 4
    end)
end	

-- The character select screen lines
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.warios = "The Great"
STRINGS.CHARACTER_NAMES.warios = "WARIO"
STRINGS.CHARACTER_DESCRIPTIONS.warios = "Studlier that a snowtire!\nStronger than cardboard!\nImma Wario, Imma gonna wien!"
STRINGS.CHARACTER_QUOTES.warios = "\"Buy my games!\""
STRINGS.CHARACTERS.WARIOS= require "speech_warios"

return MakePlayerCharacter("warios", prefabs, assets, fn, start_inv)