﻿Imports System.Net
Imports System.Net.NetworkInformation

Public Class 网络检测
    Private _process As Process = Nothing
    Private Sub Button1_Click(sender As Object, e As EventArgs) Handles Button1.Click
        Dim jg As Integer


        jg = TextBox3.Text

        Dim ips As String
        txtInfo.Text = ""
        ips = txtAddress.Text
        Dim arrip() As String = Split(ips, vbCrLf)
        For Each k As String In arrip
            If gotoPing(k) = False Then
                Dim sapi As Object
                sapi = CreateObject("sapi.spvoice")
                sapi.volume = 100
                sapi.Rate = 4.5
                sapi.Speak(k & "网络通信异常，请检测", 2)
                sapi = Nothing
            End If
        Next

        Button1.Enabled = False
        Timer1.Interval = 1000 * 60 * jg
        Timer1.Enabled = True
    End Sub


    Private Function gotoPing(ipaddr As String) As Boolean
        Dim p As New Ping()
        Dim pReply As PingReply
        Dim i As Integer
        Dim zsc As Integer = 0 '总时长
        Dim db As Integer = 0 '总失败次数
        Dim pjsc As Single '平均时长
        Dim ci As Integer '发包检测次数
        Dim yc As Integer '超时多少毫秒算网络故障
        ci = TextBox1.Text
        yc = TextBox2.Text
        txtInfo.Text &= Now() & vbCrLf
        For i = 1 To ci
            Try
                pReply = p.Send(ipaddr)
                If pReply.Status <> IPStatus.Success Then
                    txtInfo.Text &= "地址：" & ipaddr & vbCrLf
                    txtInfo.Text &= "失败：" & pReply.Status.ToString & vbCrLf
                    db += 1
                Else
                    txtInfo.Text &= pReply.Address.ToString & " - " & pReply.RoundtripTime & "ms" & vbCrLf
                    'txtInfo.Text &= "TTL：" & pReply.Options.Ttl & vbCrLf
                    'txtInfo.Text &= "答复消息所用的毫秒数：" & pReply.RoundtripTime & vbCrLf
                    zsc += pReply.RoundtripTime
                End If
            Catch ex As Exception
                txtInfo.Text &= "地址：" & ipaddr & vbCrLf
                txtInfo.Text &= "Ping发生错误：" & ex.Message & vbCrLf
                db += 1
            End Try
        Next
        pjsc = zsc / ci
        txtInfo.Text &= "平均：" & pjsc & "毫秒" & vbCrLf
        txtInfo.Text &= "错误：" & db & vbCrLf
        txtInfo.Text &= "--------------------" & vbCrLf
        Me.txtInfo.[Select](Me.txtInfo.Text.Length - 1, 0)
        Me.txtInfo.ScrollToCaret()

        If db > 0 Or pjsc > yc Then gotoPing = False Else gotoPing = True
    End Function



    '最小化到右下角 & 锁定窗口大小
    Private Sub Form1_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles MyBase.Resize

        If Me.WindowState = FormWindowState.Minimized Then
            Me.Hide()
        End If

        '这里实现窗口不允许更改大小（就是在改变窗口大小的时候锁定某一数值，实现无法改变大小的效果。另外要把最大化按钮设置为false）
        Me.Width = 687
        Me.Height = 473

    End Sub


    '双击托盘中的图标还原窗口
    Private Sub NotifyIcon1_DoubleClick(ByVal sender As Object, ByVal e As System.EventArgs) Handles NotifyIcon1.DoubleClick

        Me.ShowInTaskbar = True
        Me.Show()

        Me.WindowState = FormWindowState.Normal
    End Sub

    Private Sub Button2_Click(sender As System.Object, e As System.EventArgs) Handles Button2.Click
        '启动cmd.exe 无限输出ping localhost的结果。
        Dim psi As New ProcessStartInfo()
        Dim p As String
        p = iptext.Text
        psi.FileName = "cmd.exe"
        psi.Arguments = " /c ping " & p & " -t"
        psi.UseShellExecute = False
        psi.RedirectStandardOutput = True
        psi.CreateNoWindow = True
        _process = New Process()
        _process.StartInfo = psi
        ' 定义接收消息的Handler
        AddHandler _process.OutputDataReceived, New DataReceivedEventHandler(AddressOf Process1_OutputDataReceived)
        _process.Start()
        ' 开始接收
        _process.BeginOutputReadLine()
    End Sub
    Private Delegate Sub AddMessageHandler(ByVal msg As String)
    Private Sub Process1_OutputDataReceived(ByVal sender As Object, ByVal e As System.Diagnostics.DataReceivedEventArgs) Handles Process1.OutputDataReceived
        Dim handler As AddMessageHandler = Function(msg As String)
                                               Me.txtInfo.Text += msg + Environment.NewLine
                                               Me.txtInfo.[Select](Me.txtInfo.Text.Length - 1, 0)
                                               Me.txtInfo.ScrollToCaret()
                                           End Function
        If Me.txtInfo.InvokeRequired Then
            Me.txtInfo.Invoke(handler, e.Data)
        End If
    End Sub
    Private Sub Form1_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        Me.txtInfo.HideSelection = False
    End Sub

    Private Sub Button3_Click(sender As System.Object, e As System.EventArgs) Handles Button3.Click
        _process.CancelOutputRead()
        _process.Close()
    End Sub

    Private Sub Timer1_Tick(sender As System.Object, e As System.EventArgs) Handles Timer1.Tick
        Dim ips As String
        txtInfo.Text = ""
        ips = txtAddress.Text
        Dim arrip() As String = Split(ips, vbCrLf)
        For Each k As String In arrip
            If gotoPing(k) = False Then
                'MsgBox(k & "网络通信异常，请检测")
                Dim sapi As Object
                sapi = CreateObject("sapi.spvoice")
                sapi.volume = 100
                sapi.Rate = 4.5
                sapi.Speak(k & "网络通信异常，请检测", 2)
                sapi = Nothing
            End If
        Next
    End Sub

    Private Sub Button4_Click(sender As System.Object, e As System.EventArgs) Handles Button4.Click
        Timer1.Enabled = False
        Button1.Enabled = True
    End Sub

    Private Sub TextBox1_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles TextBox1.KeyPress
        If Char.IsDigit(e.KeyChar) Or e.KeyChar = Chr(8) Then
            e.Handled = False
        Else
            e.Handled = True
        End If
    End Sub
    Private Sub TextBox2_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles TextBox2.KeyPress
        If Char.IsDigit(e.KeyChar) Or e.KeyChar = Chr(8) Then
            e.Handled = False
        Else
            e.Handled = True
        End If
    End Sub
    Private Sub TextBox3_KeyPress(ByVal sender As Object, ByVal e As System.Windows.Forms.KeyPressEventArgs) Handles TextBox3.KeyPress
        If Char.IsDigit(e.KeyChar) Or e.KeyChar = Chr(8) Then
            e.Handled = False
        Else
            e.Handled = True
        End If
    End Sub

    Private Sub TextBox1_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextBox1.TextChanged
        If TextBox1.Text = "" Then TextBox1.Text = 4
        If Val(TextBox1.Text) <= 0 Then TextBox1.Text = 4
    End Sub

    Private Sub TextBox2_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextBox2.TextChanged
        If TextBox2.Text = "" Then TextBox2.Text = 5
        If Val(TextBox2.Text) <= 0 Then TextBox2.Text = 5
    End Sub

    Private Sub TextBox3_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextBox3.TextChanged
        If TextBox3.Text = "" Then TextBox3.Text = 1
        If Val(TextBox3.Text) <= 0 Then TextBox3.Text = 1
    End Sub
End Class
