
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
        Asset( "ANIM", "anim/wangnima.zip" ),
        Asset( "ANIM", "anim/ghost_wangnima_build.zip" ),
}
local prefabs = {}



local start_inv = {
}

local function onbecamehuman(inst)
	--inst.components.locomotor.walkspeed = 4
	--inst.components.locomotor.runspeed = 6
end

local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end

local function tough(inst)

    if inst.components.health.currenthealth < (100) then
        inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 2)
        inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 2)
        --inst.components.combat.damagemultiplier = 1.5
        inst.components.health:StartRegen(5, 10)
    else
        inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.5)
        inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.5)
        
        --inst.components.hunger.hungerrate = ( TUNING.WILSON_HUNGER_RATE * 2.50)
        inst.components.health:StartRegen(0, 0)
    end
end

local common_postinit = function(inst) 
	inst.MiniMapEntity:SetIcon( "wangnima.tex" )
end

local function ondeath(inst)
    inst.components.talker:Say((GetString(inst, "ANNOUNCE_DEATH")))
        if inst.taunt_task ~= nil then
            inst.taunt_task:Cancel()
            inst.taunt_task = nil
        end
end
  
local master_postinit = function(inst)
	inst.soundsname = "wilson"
	
	inst.components.health:SetMaxHealth(250)
	inst.components.hunger:SetMax(250)
	inst.components.sanity:SetMax(200)
	
    inst.components.combat.damagemultiplier = 1.0
    inst.components.health.absorb = 0
	
    inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.5)
    inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.5)
    inst.components.sanity.neg_aura_mult = 1.0
    inst.components.sanity.night_drain_mult = 1.0
    inst.components.sanity.neg_aura_mult = 1.0
    inst.components.sanity.night_drain_mult = 1.0
	inst.components.hunger.hungerrate = TUNING.WILSON_HUNGER_RATE
	
    inst.OnLoad = onload
    inst.OnNewSpawn = onload

    inst:ListenForEvent("healthdelta", function(inst) tough(inst) end )
    --[[inst:ListenForEvent("hungerdelta", function(inst) eager(inst) end )
    inst:ListenForEvent("sanitydelta", function(inst) might(inst) end )

    tough(inst)
    eager(inst)
    might(inst)]]--

    return inst

end

return MakePlayerCharacter("wangnima", prefabs, assets, common_postinit, master_postinit, start_inv)
