__author__ = 'chenming'

from ctypes import *
import threading
import ntpath
from utilsEx import *


class BaseAU:
    class VerifyCode(object):
        S_OK = 0
        E_INVALIDARG = 1
        E_FAILED = 2
        E_CANCELLED = 3

    def __init__(self):
        self.notifyEvent = None
        self.appId = ''
        self.appSecret = ''
        self.accessToken = ''
        self.redirectURL = ''
        self.accessError = ''
        self.userName = ''
        self.callback = None
        self.userObj = None
        self.stop = False
        self.filepath = ''
        self.title = ''
        self.desc = ''
        self.privacy = ''
        self.tags = ''
        self.category = ''
        self.thread = None
        self.limit_file_size = 0
        self.video_hd = True
        self.video_sd = True
        self.videoCategories = ''
        self.video_url = ''
        self.redirectURL = 'http://pop.wondershare.com/filmora/sns-authorization.html'

    def start_upload(self):
        return

    def SetUserObj(self, userobj):
        self.userObj = userobj
    
    def SetCallback(self, c_callback):
        PyCObject_AsVoidPtr = PYFUNCTYPE(c_void_p, py_object)(
                              ('PyCObject_AsVoidPtr', pythonapi))
        c_callbackaddr = PyCObject_AsVoidPtr(c_callback)
        CALLBACKFUNC_T = CFUNCTYPE(None, c_long, c_int, c_char_p)
        self.callback = CALLBACKFUNC_T(c_callbackaddr)

    def SendMessage(self, event, msg):
        if self.callback and self.stop == False:
            self.callback(self.userObj, event, c_char_p(msg))

    def GetLoginURL(self):
        return ''

    def Logout(self):
        return

    def VerifyRedirectURL(self, url):
        return 1

    def SetRedirectURL(self, url):
        self.redirectURL = url

    def SetAppKey(self, key):
        self.appId = key

    def SetAppSecret(self, secret):
        self.appSecret = secret

    def GetAppKey(self):
        return self.appId

    def GetAppSecret(self):
        return self.appSecret

    def GetAccessToken(self):
        return self.accessToken

    def SetAccessToken(self, token):
        self.accessToken = token

    def GetUserName(self):
        return self.userName

    def GetLimitSpace(self):
        return self.limit_file_size

    def GetVideoHD(self):
        return self.video_hd

    def GetVideoSD(self):
        return self.video_sd

    def GetVideoCategories(self):
        return self.videoCategories

    def UpdateInfo(self):
        return

    def GetLastError(self):
        return self.accessError

    def StartUpload(self, filepath, title='', desc='', privacy='', tags='', category=''):
        self.filepath = filepath
        self.title = title
        if len(title) <= 0:
            self.title = ntpath.basename(filepath)
        self.desc = desc
        self.privacy = privacy
        self.tags = tags
        self.category = category
        self.StopUpload()
        debug('------------------------------------- create upload thread ------------------------------')
        self.thread = threading.Thread(target=self.start_upload)
        self.thread.start()

    def Wait(self, timeout = None):
        self.thread.join(timeout)

    def StopUpload(self):
        debug('-------- Stop Upload ------')
        try:
            self.video_url = ''
            self.stop = True
            if self.thread != None:
                self.Wait(3)
                self.thread = None
            self.stop = False
        except Exception as e:
            debug('stop upload error: '+ str(e))