
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/gnar.zip" ),
        Asset( "ANIM", "anim/ghost_gnar_build.zip" ),
}
local prefabs = {
     "beardhair",
}
local start_inv = {

	"boomerang",
        "boneshard",
}
local function runner(inst)
	
	local max_upgrades = 20
	local upgrades = math.min(inst.level, max_upgrades)
			if TheWorld.state.phase == "day" then 
	                        inst.components.temperature.inherentinsulation = 80
                                inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1.25)
                                inst.components.sanity.night_drain_mult = 0.75
                                inst.components.sanity.neg_aura_mult = 1
				inst.components.locomotor.runspeed = 7
			elseif TheWorld.state.phase == "dusk" then
	                        inst.components.temperature.inherentinsulation = 60
                                inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*1)
                                inst.components.sanity.night_drain_mult = 0.875
                                inst.components.sanity.neg_aura_mult = 0.75
				inst.components.locomotor.runspeed = 6.75
			elseif TheWorld.state.phase == "night" then
                  	        inst.components.temperature.inherentinsulation = 40
                                inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE*0.875)
                                inst.components.sanity.night_drain_mult = 1.125
                                inst.components.sanity.neg_aura_mult = 0.5
				inst.components.locomotor.runspeed = 6.5
			end
		

end

local function gnar(inst)
	local x,y,z = inst.Transform:GetWorldPosition()
	local range = 15
	local player = TheSim:FindEntities(x, y, z, range, {"player"}, {"playerghost"})
	local count = #player - 1
	if count >= 1 then
		inst.components.sanityaura.aura = 0.75
		inst.components.sanity.dapperness = 0.01
	else
		inst.components.sanityaura.aura = 0.75
		inst.components.sanity.dapperness = -0.01
	end
end

local function applyupgrades(inst)

	if inst.level >0 then
                inst.components.combat.damagemultiplier =  0.75
                inst.components.health:SetAbsorptionAmount(-0.35)
                inst.Transform:SetScale(0.70,0.70,0.70)
                inst.components.grogginess:AddGrogginess(1, TUNING.PANFLUTE_SLEEPTIME)
	end
	if inst.level >0.4 then
                inst.Transform:SetScale(0.71,0.71,0.71)
	end
	if inst.level >0.9 then
                inst.Transform:SetScale(0.72,0.72,0.72)
	end
	if inst.level >1.4 then
                inst.components.combat.damagemultiplier =  0.78
                inst.components.health:SetAbsorptionAmount(-0.32)
                inst.Transform:SetScale(0.73,0.73,0.73)
	end
	if inst.level >1.9 then
                inst.Transform:SetScale(0.74,0.74,0.74)
	end
	if inst.level >2.4 then
                inst.Transform:SetScale(0.75,0.75,0.75)
	end
	if inst.level >2.9 then
                inst.components.combat.damagemultiplier =  0.81
                inst.components.health:SetAbsorptionAmount(-0.29)
                inst.Transform:SetScale(0.76,0.76,0.76)
	end
	if inst.level >3.4 then
                inst.Transform:SetScale(0.77,0.77,0.77)
	end
	if inst.level >3.9 then
                inst.Transform:SetScale(0.78,0.78,0.78)
	end
	if inst.level >4.4 then
                inst.components.combat.damagemultiplier =  0.84
                inst.components.health:SetAbsorptionAmount(-0.26)
                inst.Transform:SetScale(0.79,0.79,0.79)
	end
	if inst.level >4.9 then
                inst.Transform:SetScale(0.80,0.80,0.80)
	end
	if inst.level >5.4 then
                inst.Transform:SetScale(0.81,0.81,0.81)
	end
	if inst.level >5.9 then
                inst.components.combat.damagemultiplier =  0.87
                inst.components.health:SetAbsorptionAmount(-0.23)
                inst.Transform:SetScale(0.82,0.82,0.82)
                inst.components.grogginess:AddGrogginess(1, TUNING.PANFLUTE_SLEEPTIME)
	end
	if inst.level >6.4 then
                inst.Transform:SetScale(0.83,0.83,0.83)
	end
	if inst.level >6.9 then
                inst.Transform:SetScale(0.84,0.84,0.84)
	end
	if inst.level >7.4 then
                inst.components.combat.damagemultiplier =  0.90
                inst.components.health:SetAbsorptionAmount(-0.20)
                inst.Transform:SetScale(0.85,0.85,0.85)
	end
	if inst.level >7.9 then
                inst.Transform:SetScale(0.86,0.86,0.86)
	end
	if inst.level >8.4 then
                inst.Transform:SetScale(0.87,0.87,0.87)
	end
	if inst.level >8.9 then
                inst.components.combat.damagemultiplier =  0.93
                inst.components.health:SetAbsorptionAmount(-0.17)
                inst.Transform:SetScale(0.88,0.88,0.88)
                inst.components.grogginess:AddGrogginess(1, TUNING.PANFLUTE_SLEEPTIME)
	end
	if inst.level >9.4 then
                inst.Transform:SetScale(0.89,0.89,0.89)
	end
	if inst.level >9.9 then
                inst.Transform:SetScale(0.90,0.90,0.90)
	end
	if inst.level >10.4 then
                inst.components.combat.damagemultiplier =  0.96
                inst.components.health:SetAbsorptionAmount(-0.14)
                inst.Transform:SetScale(0.91,0.91,0.91)
	end
	if inst.level >10.9 then
                inst.Transform:SetScale(0.92,0.92,0.92)
	end
	if inst.level >11.4 then
                inst.Transform:SetScale(0.93,0.93,0.93)
	end
	if inst.level >11.9 then
                inst.components.grogginess:AddGrogginess(1, TUNING.PANFLUTE_SLEEPTIME)
                inst.components.health:SetAbsorptionAmount(-0.11)
                inst.components.combat.damagemultiplier =  0.99
                inst.Transform:SetScale(0.94,0.94,0.94)
	end
	if inst.level >12.4 then
                inst.Transform:SetScale(0.95,0.95,0.95)
	end
	if inst.level >12.9 then
                inst.Transform:SetScale(0.96,0.96,0.96)
	end
	if inst.level >13.4 then
                inst.components.combat.damagemultiplier =  1
                inst.components.health:SetAbsorptionAmount(-0.10)
                inst.Transform:SetScale(0.97,0.97,0.97)
	end
	if inst.level >13.9 then
                inst.Transform:SetScale(0.98,0.98,0.98)
	end
	if inst.level >14.4 then
                inst.Transform:SetScale(0.99,0.99,0.99)
	end
	if inst.level >14.9 then
                inst.components.grogginess:AddGrogginess(1, TUNING.PANFLUTE_SLEEPTIME)
                inst.components.health:SetAbsorptionAmount(-0.08)
                inst.components.combat.damagemultiplier =  1.02
                inst.Transform:SetScale(1.00,1.00,1.00)
	end
	if inst.level >15.4 then
                inst.Transform:SetScale(1.01,1.01,1.01)
	end
	if inst.level >15.9 then
                inst.Transform:SetScale(1.02,1.02,1.02)
	end
	if inst.level >16.4 then
                inst.components.combat.damagemultiplier =  1.04
                inst.components.health:SetAbsorptionAmount(-0.05)
                inst.Transform:SetScale(1.03,1.03,1.03)
	end
	if inst.level >16.9 then
                inst.Transform:SetScale(1.04,1.04,1.04)
	end
	if inst.level >17.4 then
                inst.Transform:SetScale(1.05,1.05,1.05)
	end
	if inst.level >17.9 then
                inst.components.combat.damagemultiplier =  1.06
                inst.components.health:SetAbsorptionAmount(0)
                inst.Transform:SetScale(1.06,1.06,1.06)
	end
	if inst.level >18.4 then
                inst.Transform:SetScale(1.07,1.07,1.07)
	end
	if inst.level >18.9 then
                inst.Transform:SetScale(1.08,1.08,1.08)
	end
	if inst.level >19.4 then
                inst.Transform:SetScale(1.09,1.09,1.09)
	end
        if inst.level >19.9 then
                inst.components.combat.damagemultiplier =  1.08
                inst.components.health:SetAbsorptionAmount(0.05)
                inst.Transform:SetScale(1.10,1.10,1.10)
	end
        if inst.level >20.4 then
                inst.Transform:SetScale(1.11,1.11,1.11)
	end
        if inst.level >20.9 then
                inst.Transform:SetScale(1.12,1.12,1.12)
	end
        if inst.level >21.4 then
                inst.Transform:SetScale(1.13,1.13,1.13)
	end
        if inst.level >21.9 then
                inst.Transform:SetScale(1.14,1.14,1.14)
	end
        if inst.level >23.4 then
                inst.components.health:SetAbsorptionAmount(0.07)
                inst.Transform:SetScale(1.15,1.15,1.15)
	end
        if inst.level >24.9 then
                inst.Transform:SetScale(1.16,1.16,1.16)
	end
        if inst.level >27.4 then
                inst.components.combat.damagemultiplier =  1.10
                inst.components.health:SetAbsorptionAmount(0.10)
                inst.Transform:SetScale(1.17,1.17,1.17)
	end
        if inst.level >29.9 then
                inst.Transform:SetScale(1.18,1.18,1.18)
	end
        if inst.level >34.9 then
                inst.components.health:SetAbsorptionAmount(0.15)
                inst.components.combat.damagemultiplier =  1.15
                inst.Transform:SetScale(1.19,1.19,1.19)
	end
        if inst.level >37.4 then
                inst.Transform:SetScale(1.20,1.20,1.20)
	end
        if inst.level >39.9 then

                inst.Transform:SetScale(1.21,1.21,1.21)
	end
        if inst.level >42.4 then
                inst.Transform:SetScale(1.22,1.22,1.22)
	end
        if inst.level >44.9 then
                inst.components.health:SetAbsorptionAmount(0.20)
                inst.components.combat.damagemultiplier =  1.20
                inst.Transform:SetScale(1.23,1.23,1.23)
	end
        if inst.level >47.4 then
                inst.Transform:SetScale(1.24,1.24,1.24)
	end
        if inst.level >49.9 then
                inst.components.health:SetAbsorptionAmount(0.25)
                inst.components.combat.damagemultiplier =  1.25
                inst.Transform:SetScale(1.25,1.25,1.25)
	end

	local max_upgrades = 18
	local upgrades = math.min(inst.level, max_upgrades)

	local hunger_percent = inst.components.hunger:GetPercent()
	local health_percent = inst.components.health:GetPercent()
	local sanity_percent = inst.components.sanity:GetPercent()

	inst.components.hunger.max = math.ceil (46 + upgrades * 3 ) --100
	inst.components.health.maxhealth = math.ceil (64 + upgrades * 2 ) --100
	inst.components.sanity.max = math.ceil (82 + upgrades * 1 ) --100
	
	if TheWorld.state.phase == "day" then 
			        inst.components.locomotor.walkspeed = math.ceil (4 + upgrades / 6)
				inst.components.locomotor.runspeed = math.ceil (6 + upgrades / 12)
			elseif TheWorld.state.phase == "dusk" then
				inst.components.locomotor.walkspeed = math.ceil (4 + upgrades / 12)
				inst.components.locomotor.runspeed = math.ceil (6 + upgrades / 12)
			elseif TheWorld.state.phase == "night" then
				inst.components.locomotor.walkspeed =  6
				inst.components.locomotor.runspeed = 9
			end

	inst.components.talker:Say("Level : ".. (inst.level))
	
	if inst.level >17.9 then
                inst.components.talker:Say("Level 18 : Statistics are Max!")
	end
        if inst.level >34.9 then
                inst.components.talker:Say("Level 35 : Pefabs are Max!")
	end
        if inst.level >49.9 then
                inst.components.talker:Say("Level 50 : All Max!")
	end
        if inst.level >99.9 then
                inst.components.talker:Say("Level 100 : That isn't ending?!")
	end
        if inst.level >199.9 then
                inst.components.talker:Say("Level 200 : Can you stop it?!")
	end
        if inst.level >249.9 then
                inst.components.talker:Say("Level 250 : Hah, just 1/4 thousand!")
	end
        if inst.level >299.9 then
                inst.components.talker:Say("Level 300 : Let's take a nap!")
	end
        if inst.level >399.9 then
                inst.components.talker:Say("Level 400 : Never enging! Never enging! Never enging!")
	end
        if inst.level >499.9 then
                inst.components.talker:Say("Level 500 : Pff, you are in half!")
	end
        if inst.level >665.9 then
                inst.components.talker:Say("Level 666 : This is the... devil!")
	end
        if inst.level >899.9 then
                inst.components.talker:Say("IT'S OVER 900!")
	end
        if inst.level >999.9 then
                inst.components.talker:Say("Level 1000 : Well done!")
	end
        if inst.level >1499.9 then
                inst.components.talker:Say("Level 1500 : 100-900.")
	end
        if inst.level >1999.9 then
                inst.components.talker:Say("Level 2000 : You want more?!")
	end
        if inst.level >2499.9 then
                inst.components.talker:Say("Level 2500 : Niiice!")
	end
        if inst.level >3332.9 then
                inst.components.talker:Say("Level 3333 : Only three is true number!")
	end
        if inst.level >3999.9 then
                inst.components.talker:Say("Level 4000 : How much I need ?")
	end
        if inst.level >4999.9 then
                inst.components.talker:Say("Level 5000 : Please stop this...")
	end

	inst.components.hunger:SetPercent(hunger_percent)
	inst.components.health:SetPercent(health_percent)
	inst.components.sanity:SetPercent(sanity_percent)
	
	runner(inst)
end
	
local function oneat(inst, food)
	
	if food and food.components.edible and food.prefab == "royal_jelly"  then
		inst.level = inst.level + 50
		applyupgrades(inst)	
			inst.components.health:DoDelta(10)
			inst.components.hunger:DoDelta(25)
			inst.components.sanity:DoDelta(15)
                inst.SoundEmitter:PlaySound("dontstarve/HUD/XP_bar_fill_unlock")
	end
	if food and food.components.edible and food.prefab == "mandrake"  then
		inst.level = inst.level + 5
		applyupgrades(inst)	
			inst.components.sanity:DoDelta(15)
                inst.SoundEmitter:PlaySound("dontstarve/HUD/XP_bar_fill_unlock")
	end
	if food and food.components.edible and food.prefab == "tallbirdegg"  then
		inst.level = inst.level + 0.75
		applyupgrades(inst)	
			inst.components.health:DoDelta(3)
			inst.components.hunger:DoDelta(5)
			inst.components.sanity:DoDelta(5)
                inst.SoundEmitter:PlaySound("dontstarve/HUD/XP_bar_fill_unlock")
	end
	if food and food.components.edible and food.prefab == "turkeydinner"  then
		inst.level = inst.level + 0.75
		applyupgrades(inst)	
			inst.components.health:DoDelta(10)
			inst.components.sanity:DoDelta(5)
                inst.SoundEmitter:PlaySound("dontstarve/HUD/XP_bar_fill_unlock")
	end
	if food and food.components.edible and food.prefab == "butter"  then
		inst.level = inst.level + 1
		applyupgrades(inst)	
			inst.components.sanity:DoDelta(15)
	end
	if food and food.components.edible and food.prefab == "drumstick_cooked"  then
		inst.level = inst.level + 0.25
		applyupgrades(inst)	
			inst.components.health:DoDelta(1)
			inst.components.sanity:DoDelta(2)
                inst.SoundEmitter:PlaySound("dontstarve/HUD/XP_bar_fill_unlock")
	end
	if food and food.components.edible and food.prefab == "drumstick"  then
		inst.level = inst.level + 0.25
		applyupgrades(inst)	
			inst.components.hunger:DoDelta(-2.5)
			inst.components.health:DoDelta(3)
			inst.components.sanity:DoDelta(2)
                inst.SoundEmitter:PlaySound("dontstarve/HUD/XP_bar_fill_unlock")
	end
        if food and food.components.edible and food.prefab == "red_cap"  then
		inst.level = inst.level + 0.5
			inst.components.hunger:DoDelta(3)
			inst.components.sanity:DoDelta(-2)
		applyupgrades(inst)	
                inst.SoundEmitter:PlaySound("dontstarve/HUD/XP_bar_fill_unlock")
	end
        if food and food.components.edible and food.prefab == "green_cap"  then
			inst.components.health:DoDelta(-5)
			inst.components.hunger:DoDelta(2.5)
			inst.components.sanity:DoDelta(-10)	
	end
        if food and food.components.edible and food.prefab == "red_cap_cooked"  then
		inst.level = inst.level + 0.25
		applyupgrades(inst)
			inst.components.hunger:DoDelta(5)
			inst.components.health:DoDelta(-1)
			inst.components.sanity:DoDelta(5)
                inst.SoundEmitter:PlaySound("dontstarve/HUD/XP_bar_fill_unlock")	
	end
	if food and food.components.edible and food.prefab == "honey"  then	
			inst.components.health:DoDelta(-4)
			inst.components.hunger:DoDelta(0.6)
			inst.components.sanity:DoDelta(3)
	end
	if food and food.components.edible and food.prefab == "meat"  then	
			inst.components.health:DoDelta(4)
			inst.components.hunger:DoDelta(-5)
			inst.components.sanity:DoDelta(2)
	end
	if food and food.components.edible and food.prefab == "cookedmeat"  then	
			inst.components.health:DoDelta(1)
			inst.components.sanity:DoDelta(2)
	end
	if food and food.components.edible and food.prefab == "smallmeat"  then	
			inst.components.health:DoDelta(3)
			inst.components.hunger:DoDelta(-2.5)
			inst.components.sanity:DoDelta(2)
	end
	if food and food.components.edible and food.prefab == "cookedsmallmeat"  then	
			inst.components.health:DoDelta(1)
			inst.components.sanity:DoDelta(2)
	end
	if food and food.components.edible and food.prefab == "butterflywings"  then	
			inst.components.health:DoDelta(-3)
			inst.components.sanity:DoDelta(1)
	end
	if food and food.components.edible and food.prefab == "fish"  then	
			inst.components.health:DoDelta(4)
			inst.components.hunger:DoDelta(-2.5)
			inst.components.sanity:DoDelta(5)
	end
end

local function onpreload(inst, data)
	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
			if data.health and data.health.health then inst.components.health.currenthealth = data.health.health end
			if data.hunger and data.hunger.hunger then inst.components.hunger.current = data.hunger.hunger end
			if data.sanity and data.sanity.current then inst.components.sanity.current = data.sanity.current end
			inst.components.health:DoDelta(3)
			inst.components.hunger:DoDelta(1)
			inst.components.sanity:DoDelta(5)
		end
	end

end

local function OnResetBeard(inst)

end

local BEARD_DAYS = { 3, 6, 9 }
local BEARD_BITS = { 1, 2, 3 }

local function OnGrowShortBeard(inst)

    inst.components.beard.bits = BEARD_BITS[1]
end

local function OnGrowMediumBeard(inst)

    inst.components.beard.bits = BEARD_BITS[2]
end

local function OnGrowLongBeard(inst)

    inst.components.beard.bits = BEARD_BITS[3]
end

local function onsave(inst, data)
	data.level = inst.level
	data.charge_time = inst.charge_time
end


-- This initializes for both clients and the host
local common_postinit = function(inst) 
	inst:AddComponent("sanityaura")
	inst.MiniMapEntity:SetIcon( "gnar.tex" )
        inst.components.talker.colour = Vector3(0.41, 0.48, 0.51, 0)
end


-- This initializes for the host only
local master_postinit = function(inst)
	inst:AddComponent("beard")
    inst.components.beard.onreset = OnResetBeard
    inst.components.beard.prize = "furtuft"
    inst.components.beard:AddCallback(BEARD_DAYS[1], OnGrowShortBeard)
    inst.components.beard:AddCallback(BEARD_DAYS[2], OnGrowMediumBeard)
    inst.components.beard:AddCallback(BEARD_DAYS[3], OnGrowLongBeard)
        inst.soundsname = "wallace"
        inst.level = 0
	inst.components.eater:SetOnEatFn(oneat)
	applyupgrades(inst)

	inst.components.builder:UnlockRecipe("boomerang")
        inst.components.builder:UnlockRecipe("boadrs")
	inst:DoPeriodicTask(1, gnar)
	inst.components.temperature.hurtrate = 1.2 * (TUNING.WILSON_HEALTH / TUNING.FREEZING_KILL_TIME)
        inst.components.eater.strongstomach = true
	inst.components.eater.ignoresspoilage = true
        inst.components.eater:SetCanEatRaw()
        inst.components.health:SetAbsorptionAmount(-0.40)
        inst.components.combat.damagemultiplier =  0.70
        inst.components.health.fire_damage_scale = 5
	inst.components.temperature.overheattemp = 65
	inst.components.health:SetMaxHealth(60)
	inst.components.hunger:SetMax(40)
	inst.components.sanity:SetMax(80)
        inst.components.moisture.baseDryingRate = - 1
        inst.Transform:SetScale(0.70,0.70,0.70)

	inst.OnSave = onsave
	inst.OnPreLoad = onpreload
	
	
	inst:ListenForEvent("clocktick", function() runner(inst) end, TheWorld)
end

return MakePlayerCharacter("gnar", prefabs, assets, common_postinit, master_postinit, start_inv)
