unit UnitFrmMain;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.ExtCtrls, Vcl.StdCtrls, Vcl.Menus,
  Vcl.ComCtrls;

type
  TfrmMain = class(TForm)
    ColorDialog1: TColorDialog;
    Label1: TLabel;
    pnl4: TPanel;
    pnlColor0: TPanel;
    pnlColor1: TPanel;
    pnlColor2: TPanel;
    pnlColor3: TPanel;
    pnlColor6: TPanel;
    pnlColor4: TPanel;
    pnlColor5: TPanel;
    pnlColor7: TPanel;
    MainMenu1: TMainMenu;
    About1: TMenuItem;
    About2: TMenuItem;
    GroupBox1: TGroupBox;
    cbxItemName: TComboBox;
    pnlColor: TPanel;
    btnEdit: TButton;
    btnRefresh: TButton;
    GroupBox2: TGroupBox;
    pnl1: TPanel;
    pnlStarMenu: TPanel;
    pnlIcon1: TPanel;
    pnlIcon2: TPanel;
    pnlIcon3: TPanel;
    pnlTile: TPanel;
    pnlTaskbar: TPanel;
    pnlStartButton: TPanel;
    pnlStarButtonHover: TPanel;
    pnlForeground: TPanel;
    pnlRunning2: TPanel;
    pnlTaskbarIcon: TPanel;
    pnlRunning1: TPanel;
    pnlWantsFocus: TPanel;
    pnlRunning3: TPanel;
    pnlProgram: TPanel;
    pnlTitlebar: TPanel;
    pnlPreviewFore: TPanel;
    pnlForegroundBox: TPanel;
    pnlPreviewBack: TPanel;
    pnlBackgroundBox: TPanel;
    cbShowTrans: TCheckBox;
    lblItemName: TLabel;
    StatusBar1: TStatusBar;
    procedure pnlClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure cbShowTransClick(Sender: TObject);
    procedure cbxItemNameClick(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
    procedure btnRefreshClick(Sender: TObject);
    procedure About2Click(Sender: TObject);
    procedure pnlColor0Click(Sender: TObject);
    procedure pnlColorClick(Sender: TObject);
    procedure pnlStarButtonHoverMouseEnter(Sender: TObject);
    procedure pnlStarButtonHoverMouseLeave(Sender: TObject);
    procedure pnlForegroundBoxMouseEnter(Sender: TObject);
    procedure pnlBackgroundBoxMouseEnter(Sender: TObject);
  private
    { Private declarations }
    accentColorMenu : integer;
    accentPalette : array[0..7] of integer;
    colorizationColor : integer;
    DWMaccentColor : integer;
    procedure loadColors;
    procedure showColors;
    procedure saveColors;


  public
    { Public declarations }
    procedure refresh;
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

uses Registry, ShellApi, Math, ShlObj , UnitFrmAbout;

function convertFrom(color : integer) : integer;
begin
    result := (color and $ff0000) shr 16;
    result := result or (color and $00FF00);
    result := result or (color and $FF shl 16);
end;





procedure TfrmMain.pnlBackgroundBoxMouseEnter(Sender: TObject);
begin
    pnlPreviewBack.BevelOuter := bvSpace;
end;

procedure TfrmMain.pnlClick(Sender: TObject);
var
    p : TPanel;
begin
    p := TPanel(Sender);
    cbxItemName.ItemIndex := p.Tag;
    cbxItemNameClick(cbxItemName);
end;
procedure TfrmMain.pnlColor0Click(Sender: TObject);
begin
    cbxItemName.ItemIndex :=  4;
    cbxItemNameClick(nil);
end;

procedure TfrmMain.pnlColorClick(Sender: TObject);
begin
    btnEdit.Click;
end;

procedure TfrmMain.pnlForegroundBoxMouseEnter(Sender: TObject);
begin
    pnlPreviewFore.BevelOuter := bvSpace;
end;

procedure TfrmMain.pnlStarButtonHoverMouseEnter(Sender: TObject);
var
    p : TPanel;
begin
    p := TPanel(Sender);
    p.BevelOuter := bvSpace;
end;

procedure TfrmMain.pnlStarButtonHoverMouseLeave(Sender: TObject);
var
    p : TPanel;
begin
    p := TPanel(Sender);
    p.BevelOuter := bvNone;

end;

procedure TfrmMain.About2Click(Sender: TObject);
begin
    FrmAbout.show;
end;

procedure TfrmMain.btnEditClick(Sender: TObject);
const
    cs1 : pchar = 'ColorizationColor';
    cs2 : pchar = 'AccentPalette';
    cs3 : pchar = 'AccentColorMenu';
    cs4 : pchar = 'ColorizationAfterglow';
    cs5 : pchar = 'DWM';
    cs6 : pchar = 'Windows';

var
    h : THandle;
begin
    case cbxItemName.ItemIndex of
    0: ColorDialog1.Color :=  accentPalette[2] ;
    1: ColorDialog1.Color :=   accentPalette[5] ;
    2: ColorDialog1.Color :=  accentPalette[3];
    3: ColorDialog1.Color :=  accentPalette[6];
    4: ColorDialog1.Color := accentPalette[1] ;
    5:ColorDialog1.Color := convertFrom(colorizationColor);
    6: ColorDialog1.Color := accentColorMenu;
    7: ColorDialog1.Color := accentPalette[4]  ;
    8: ColorDialog1.Color := DWMaccentColor;
    end;


    if ColorDialog1.Execute(self.Handle) then begin
        case cbxItemName.ItemIndex of
        0:  accentPalette[2] := ColorDialog1.Color;
        1:   accentPalette[5] := ColorDialog1.Color;
        2:  accentPalette[3] := ColorDialog1.Color;
        3:  accentPalette[6] := ColorDialog1.Color;
        4: accentPalette[1] := ColorDialog1.Color;
        5: colorizationColor := convertFrom(ColorDialog1.Color) or $C4000000;
        6: accentColorMenu := ColorDialog1.Color;
        7: accentPalette[4]  := ColorDialog1.Color;
        8 : DWMaccentColor := ColorDialog1.Color;
        end;

        saveColors;
        showColors;


    end;


end;
procedure TfrmMain.btnRefreshClick(Sender: TObject);
begin

    self.refresh;
//    ShellExecute(Handle, 'runas', 'wincolor.exe', '-refresh', nil, SW_SHOWNORMAL);
//    ShellExecute(Handle, 'open', 'wincolor.exe', '-refresh', nil, SW_SHOWNORMAL);
end;



procedure TfrmMain.cbShowTransClick(Sender: TObject);
begin
    frmMain.AlphaBlend := cbShowTrans.Checked;
end;
procedure TfrmMain.cbxItemNameClick(Sender: TObject);
begin
    case cbxItemName.ItemIndex of
    0:  pnlColor.Color := accentPalette[2];
    1:  pnlColor.Color := accentPalette[5];
    2: pnlColor.Color := accentPalette[3];
    3: pnlColor.Color := accentPalette[6];
    4:pnlColor.Color := accentPalette[1];
    5:pnlColor.Color := convertFrom(colorizationColor);
    6:pnlColor.Color := accentColorMenu;
    7:pnlColor.Color := accentPalette[4] ;
    8: //pnlColor.Color := convertFrom(colorizationColor);
        pnlColor.color := DWMaccentColor;
    end;

    lblItemName.Caption := cbxItemName.Text;
end;



procedure TfrmMain.FormCreate(Sender: TObject);
begin
    loadColors;
    showColors;
end;




function mix(color1, color2 : integer; color1Percent : double) : integer;
var
    r, g, b : byte;
begin
    r := trunc(GetRValue(color1) * color1Percent);
    g := trunc(GetGValue(color1) * color1Percent);
    b := trunc(GetBValue(color1) * color1Percent);

    inc(r, trunc(GetRValue(color2) * (1-color1Percent)));
    inc(g, trunc(GetGValue(color2) * (1-color1Percent)));
    inc(b, trunc(GetBValue(color2) * (1-color1Percent)));

    result := rgb(r,g,b);
end;

const
    DWM_ACCENT_COLOR = 'AccentColor';
procedure TfrmMain.loadColors;
var
    r : TRegistry;
    i, cnt : integer;
    st : TStringList;
    s : string;
    clr, clr2 : integer;
const
    ACCENT_COLOR_MENU = 'AccentColorMenu';
    DWM_ACCENT_COLOR = 'AccentColor';
begin
    r := TREgistry.create(KEY_READ);
    r.RootKey := HKEY_CURRENT_USER;
    r.Access := KEY_ALL_ACCESS;


    if r.OpenKeyReadOnly('SOFTWARE\Microsoft\Windows\DWM\') then begin
        colorizationColor := r.ReadInteger('ColorizationColor');
        if r.ValueExists(DWM_ACCENT_COLOR) then  begin
            DWMaccentColor :=  r.ReadInteger(DWM_ACCENT_COLOR) ;
        end else begin
            DWMaccentColor :=  colorizationColor;
        end;
        r.CloseKey;
    end else begin
        showmessage('1'+r.LastErrorMsg);
    end;

    r.RootKey := HKEY_CURRENT_USER;
    if r.OpenKeyReadOnly('SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Accent') then begin
        if r.ValueExists(ACCENT_COLOR_MENU) then begin
            accentColorMenu := r.ReadInteger(ACCENT_COLOR_MENU) and $FFFFFF;
         end;
         i := sizeof(accentPalette);
         cnt := r.ReadBinaryData('AccentPalette', accentPalette, i);

         r.CloseKey
    end else begin
        ShowMessage('2'+r.LastErrorMsg);
    end;
end;
procedure TfrmMain.saveColors;
var
    r : TRegistry;
    i, cnt : integer;

begin
    r := TREgistry.create;
    r.RootKey := HKEY_CURRENT_USER;
    r.Access := KEY_ALL_ACCESS;


    if r.OpenKey('SOFTWARE\Microsoft\Windows\DWM',false) then begin
        r.WriteInteger('ColorizationColor',colorizationColor);
        r.WriteInteger('ColorizationAfterglow',colorizationColor);
        r.WriteInteger(DWM_ACCENT_COLOR, DWMaccentColor);
        r.CloseKey;
    end else begin
        showmessage('1'+r.LastErrorMsg);
    end;

    r.RootKey := HKEY_CURRENT_USER;
    if r.OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer\Accent',false) then begin

        r.WriteInteger('AccentColorMenu', accentColorMenu or $ff000000);
        i := sizeof(accentPalette);
        r.WriteBinaryData('AccentPalette', accentPalette, i);
        r.CloseKey
    end else begin
        ShowMessage('2'+r.LastErrorMsg);
    end;


end;
procedure TfrmMain.showColors;
var
    clr, clr2 : integer;

    function fixACM(color :integer) : integer;
    var
        r,g,b : byte;
        c : byte;
    begin
        r := GetRValue(color);
        g := GetGValue(color);
        b := GetBValue(color);

        if (g>220) then begin
            if (r>220) then begin
                c := Abs(g-b);
                b := b + c;
                r := c;
            end else begin
                c := Abs(g-b);
                b := math.min(b + c, 210);
                if (g-c)<c then begin
                    g := c;
                end else begin
                    g := trunc(g * 0.56);
                end;
            end;
        end else begin
            r := Math.min(r,220);
        end;
        result := RGB(r,g,b);
    end;
begin
    pnlColor0.Color := accentPalette[0];
    pnlColor1.Color := accentPalette[1];
    pnlColor2.Color := accentPalette[2];
    pnlColor3.Color := accentPalette[3];
    pnlColor4.Color := accentPalette[4];
    pnlColor5.Color := accentPalette[5];
    pnlColor6.Color := accentPalette[6];
    pnlColor7.Color := accentPalette[7];


    pnlProgram.Color := $FFFFFF;
    pnlStarButtonHover.Color := accentPalette[2];

    pnlPreviewBack.Color := accentPalette[4];
    pnlPreviewFore.Color := fixACM(accentColorMenu);

    pnlStarMenu.color := accentPalette[5];
    pnlTaskbar.Color := accentPalette[6];
    pnlTaskbarIcon.Color := accentPalette[6];
    pnlWantsFocus.Color := accentPalette[0];


    clr := accentPalette[1];
    clr := mix(clr,clWhite, 0.50);
    pnlRunning1.Color := clr;
    pnlRunning2.Color := clr;
    pnlRunning3.Color := clr;


    clr2 := accentPalette[3];
    pnlIcon1.Color := clr2;
    pnlIcon2.Color := clr2;
    pnlIcon3.Color := clr2;
    pnlTile.Color := clr2;
    pnlForeground.Color := mix(clr2, pnlTaskbar.Color, 0.50);


    clr := DWMaccentColor;
    pnlTitlebar.Color :=  clr;


    cbxItemNameClick(cbxItemName);
end;


type
tagCOLORIZATIONPARAMS = record
clrColor        : COLORREF;  //ColorizationColor
clrAftGlow      : COLORREF;  //ColorizationAfterglow
nIntensity      : UINT;      //ColorizationColorBalance -> 0-100
clrAftGlowBal   : UINT;      //ColorizationAfterglowBalance
clrBlurBal      : UINT;      //ColorizationBlurBalance
clrGlassReflInt : UINT;      //ColorizationGlassReflectionIntensity
fOpaque         : BOOL;
end;

COLORIZATIONPARAMS=tagCOLORIZATIONPARAMS;
TColorizationParams=COLORIZATIONPARAMS;
PColorizationParams=^TColorizationParams;

TDwmIsCompositionEnabled      = function(out pfEnabled : BOOL): HRESULT; stdcall;
TDwmGetColorizationParameters = procedure(out parameters :TColorizationParams); stdcall;
TDwmSetColorizationParameters = procedure(parameters :PColorizationParams;unknown:BOOL); stdcall;

var
 DwmGetColorizationParameters : TDwmGetColorizationParameters;
 DwmSetColorizationParameters : TDwmSetColorizationParameters;
 DwmIsCompositionEnabled      : TDwmIsCompositionEnabled;
 DwmPRestartComposition : function() : HRESULT; stdcall;



procedure TfrmMain.refresh;
const
    msg : pchar = 'Desktop';
    msg2 : pchar = 'WindowMetrics';
    msg3 : pchar = 'Environment';
    msg4 : pchar = 'ImmersiveColorSet';
    msg5 : pchar = 'Explorer';
    msg6 : pchar = 'Policy';
    DBT_DEVNODES_CHANGED = 7;
var
    h : THandle;
    taskH : THandle;
    cp : TColorizationParams;
    r : TRegistry;
    I : integer;
    sl : TStringList;
    result : Cardinal;

    procedure setBoolean(name : string; value : integer);
    begin
        r := TRegistry.Create;
        r.RootKey := HKEY_CURRENT_USER;
        if r.OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion\Themes\Personalize',false) then begin
            r.WriteInteger(name, value);
            r.CloseKey
        end else begin
            ShowMessage('2'+r.LastErrorMsg);
        end;
        r.Free;
    end;

    procedure restartExplorer;
    begin
        sl := TStringList.Create;
        sl.Add('taskkill /f /IM explorer.exe');
        sl.Add('%SYSTEMROOT%\explorer.exe');
        sl.SaveToFile('restart_explorer.bat');
        ShellExecute(GetDesktopWindow, 'open', 'restart_explorer.bat', nil, nil, SW_HIDE);
    end;

    procedure setTitle;
    begin
        DwmGetColorizationParameters(cp);
        cp.clrColor := colorizationColor;
        cp.clrAftGlow := colorizationColor;
        DwmSetColorizationParameters(@cp,bool(0));
    end;
begin
//    h := HWND_BROADCAST;
    h := GetDesktopWindow;



    setTitle;
    restartExplorer;

//    taskH := FindWindow('Desktop',nil);
//    InvalidateRect(taskH,nil,true);


//    SHChangeNotify(SHCNE_ASSOCCHANGED, SHCNF_FLUSHNOWAIT, nil, nil);
    // this update icons on the taskbar


//    SendMessage(HWND_BROADCAST, WM_SETTINGCHANGE, SPI_SETNONCLIENTMETRICS,
//        longint(msg2));

//    SendMessageTimeout( HWND_BROADCAST, WM_SETTINGCHANGE,
//        SPI_SETNONCLIENTMETRICS, 0, SMTO_ABORTIFHUNG, 5000, result);

//    SendNotifyMessage(HWND_BROADCAST,WM_SETTINGCHANGE, 0, longint(msg));
//    SendNotifyMessage(HWND_BROADCAST,WM_SETTINGCHANGE, 0, longint(msg4));
//    SendNotifyMessage(HWND_BROADCAST,WM_DWMNCRENDERINGCHANGED, 1, 0);



//    sleep(100);
//    setBoolean('EnableTransparency', 1);
//    DwmGetColorizationParameters(cp);
//    cp.clrColor := colorizationColor;
//    cp.clrAftGlow := colorizationColor;
//    DwmSetColorizationParameters(@cp,bool(0));



   

//    r := TRegistry.Create;
//    r.RootKey := HKEY_CURRENT_USER;
//    if r.OpenKey('SOFTWARE\Microsoft\Windows\CurrentVersion\Themes\Personalize',false) then begin
//        r.WriteInteger('ColorPrevalence', 1);
//        r.CloseKey
//    end else begin
//        ShowMessage('2'+r.LastErrorMsg);
//    end;
//    taskH := FindWindow('Shell_TrayWnd',nil);
//    SendMessage(HWND_BROADCAST, WM_SETTINGCHANGE, 0, longint(msg));
//    SendMessage(HWND_BROADCAST, WM_SETTINGCHANGE, 0, longint(msg2));
//    SetWindowPos(taskH,0,0,0,0,0,SWP_NOSIZE or SWP_NOMOVE);
//
//    SendMessage(taskH, WM_DEVICECHANGE, DBT_DEVNODES_CHANGED, 0);


//    ShowMessage(IntToStr(DwmPRestartComposition));


end;




var hdwmapi : THandle;
initialization
begin
    hdwmapi := LoadLibrary('dwmapi.dll');
    if (hdwmapi <> 0) then begin
        @DwmIsCompositionEnabled      := GetProcAddress(hdwmapi, 'DwmIsCompositionEnabled');
        @DwmGetColorizationParameters := GetProcAddress(hdwmapi, LPCSTR(127));
        @DwmSetColorizationParameters := GetProcAddress(hdwmapi, LPCSTR(131));
        @DwmPRestartComposition := GetProcAddress(hdwmapi, LPCSTR(103));
    end;
end;

end.
