/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import corgitaco.betterweather.BetterWeatherClientUtil;
import corgitaco.betterweather.BetterWeatherUtil;
import corgitaco.betterweather.api.SeasonData;
import corgitaco.betterweather.api.weatherevent.WeatherData;
import corgitaco.betterweather.compat.OptifineCompat;
import corgitaco.betterweather.config.BetterWeatherConfig;
import corgitaco.betterweather.config.BetterWeatherConfigClient;
import corgitaco.betterweather.datastorage.network.NetworkHandler;
import corgitaco.betterweather.datastorage.network.packet.GeneralPacket;
import corgitaco.betterweather.season.SeasonSystem;
import corgitaco.betterweather.server.BetterWeatherGameRules;
import corgitaco.betterweather.server.ConfigReloadCommand;
import corgitaco.betterweather.server.SetSeasonCommand;
import corgitaco.betterweather.server.SetWeatherCommand;
import corgitaco.betterweather.weatherevent.WeatherEventSystem;
import corgitaco.betterweather.weatherevent.weatherevents.vanilla.Clear;
import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.lang3.text.WordUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="betterweather")
public class BetterWeather {
    public static final String MOD_ID = "betterweather";
    public static final Path CONFIG_PATH = new File(String.valueOf(FMLPaths.CONFIGDIR.get().resolve("betterweather"))).toPath();
    public static Logger LOGGER = LogManager.getLogger();
    public static int SEASON_LENGTH = 240000;
    public static int SEASON_CYCLE_LENGTH = SEASON_LENGTH * 4;
    public static boolean useSeasons = true;
    public static boolean usingOptifine;
    public static Registry<Biome> biomeRegistryEarlyAccess;
    public static final Clear DUMMY_CLEAR;

    public BetterWeather() {
        File dir = new File(CONFIG_PATH.toString());
        if (!dir.exists()) {
            dir.mkdir();
        }
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::lateSetup);
        BetterWeatherConfig.loadConfig(CONFIG_PATH.resolve("betterweather-common.toml"));
        BetterWeatherConfigClient.loadConfig(CONFIG_PATH.resolve("betterweather-client.toml"));
    }

    public static void loadClientConfigs() {
        BetterWeatherConfigClient.loadConfig(CONFIG_PATH.resolve("betterweather-client.toml"));
        BetterWeatherClientUtil.loadSeasonConfigsClient();
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LOGGER.debug("Registering Better Weather commands...");
        LiteralArgumentBuilder requires = (LiteralArgumentBuilder)Commands.func_197057_a((String)MOD_ID).requires(commandSource -> commandSource.func_197034_c(3));
        if (useSeasons) {
            requires.then(SetSeasonCommand.register(dispatcher));
        }
        LiteralCommandNode source = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)requires.then(SetWeatherCommand.register(dispatcher))).then(ConfigReloadCommand.register(dispatcher)));
        dispatcher.register((LiteralArgumentBuilder)Commands.func_197057_a((String)MOD_ID).redirect((CommandNode)source));
        LOGGER.debug("Registered Better Weather Commands!");
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        BetterWeatherConfig.handleCommonConfig();
        WeatherEventSystem.addDefaultWeatherEvents();
        NetworkHandler.init();
        event.enqueueWork(BetterWeatherGameRules::init);
    }

    public void lateSetup(FMLLoadCompleteEvent event) {
        WeatherEventSystem.fillWeatherEventsMapAndWeatherEventController();
        WeatherData.currentWeatherEvent = DUMMY_CLEAR;
    }

    public void clientSetup(FMLClientSetupEvent event) {
        usingOptifine = (Boolean)OptifineCompat.IS_OPTIFINE_PRESENT.func_179281_c();
    }

    static {
        DUMMY_CLEAR = new Clear();
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class BetterWeatherClient {
        @SubscribeEvent
        public static void renderFogEvent(EntityViewRenderEvent.FogDensity event) {
            Minecraft minecraft = Minecraft.func_71410_x();
            ClientWorld world = minecraft.field_71441_e;
            if (world != null && BetterWeatherUtil.isOverworld((RegistryKey<World>)world.func_234923_W_())) {
                WeatherData.currentWeatherEvent.handleFogDensity(event, minecraft);
            }
        }

        @SubscribeEvent
        public static void renderGameOverlayEventText(RenderGameOverlayEvent.Text event) {
            if (useSeasons && Minecraft.func_71410_x().field_71474_y.field_74330_P) {
                event.getLeft().add("Season: " + WordUtils.capitalize((String)SeasonData.currentSeason.toString().toLowerCase()) + " | " + WordUtils.capitalize((String)SeasonData.currentSubSeason.toString().replace("_", "").replace(SeasonData.currentSeason.toString(), "").toLowerCase()));
            }
        }

        @SubscribeEvent
        public static void loggedInEvent(ClientPlayerNetworkEvent.LoggedInEvent event) {
            BetterWeather.loadClientConfigs();
        }
    }

    @Mod.EventBusSubscriber(modid="betterweather", bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class BetterWeatherEvents {
        @SubscribeEvent
        public static void worldTick(TickEvent.WorldTickEvent event) {
            ServerWorld serverWorld;
            if (event.phase == TickEvent.Phase.END && event.side.isServer() && BetterWeatherUtil.isOverworld((RegistryKey<World>)(serverWorld = (ServerWorld)event.world).func_234923_W_())) {
                World world = event.world;
                int tickSpeed = world.func_82736_K().func_223592_c(GameRules.field_223610_m);
                long worldTime = world.func_72912_H().func_82573_f();
                if (useSeasons) {
                    SeasonSystem.updateSeasonTime(event.world);
                    SeasonSystem.updateSeasonPacket(serverWorld.func_217369_A(), world, false);
                }
                if (worldTime % 10L == 0L) {
                    WeatherEventSystem.updateWeatherEventPacket(serverWorld, serverWorld.func_217369_A(), false);
                }
                WeatherData.currentWeatherEvent.worldTick(serverWorld, tickSpeed, worldTime);
            }
        }

        @SubscribeEvent
        public static void renderTickEvent(TickEvent.RenderTickEvent event) {
        }

        @SubscribeEvent
        public static void worldLoadEvent(WorldEvent.Load event) {
        }

        @SubscribeEvent
        public static void playerTickEvent(TickEvent.PlayerTickEvent event) {
        }

        @SubscribeEvent
        public static void entityTickEvent(LivingEvent.LivingUpdateEvent event) {
            WeatherData.currentWeatherEvent.livingEntityUpdate(event.getEntity());
        }

        @SubscribeEvent
        public static void onPlayerJoined(PlayerEvent.PlayerLoggedInEvent event) {
            BetterWeatherEvents.updateGeneralDataPacket(Collections.singletonList((ServerPlayerEntity)event.getPlayer()));
            if (useSeasons) {
                SeasonSystem.updateSeasonPacket(Collections.singletonList((ServerPlayerEntity)event.getPlayer()), event.getPlayer().field_70170_p, true);
            }
            WeatherEventSystem.updateWeatherEventPacket(((ServerPlayerEntity)event.getPlayer()).func_71121_q(), Collections.singletonList((ServerPlayerEntity)event.getPlayer()), true);
        }

        public static void updateGeneralDataPacket(List<ServerPlayerEntity> players) {
            players.forEach(player -> NetworkHandler.sendToClient(player, new GeneralPacket(useSeasons)));
        }

        @SubscribeEvent
        public static void clientTickEvent(TickEvent.ClientTickEvent event) {
            Minecraft minecraft = Minecraft.func_71410_x();
            if (event.phase == TickEvent.Phase.START && minecraft.field_71441_e != null && minecraft.field_71439_g != null && BetterWeatherUtil.isOverworld((RegistryKey<World>)minecraft.field_71441_e.func_234923_W_())) {
                int tickSpeed = minecraft.field_71441_e.func_82736_K().func_223592_c(GameRules.field_223610_m);
                if (useSeasons && minecraft.field_71441_e.func_72912_H().func_82573_f() % 10L == 0L) {
                    SeasonSystem.clientSeason(minecraft.field_71441_e);
                }
                WeatherData.currentWeatherEvent.clientTick(minecraft.field_71441_e, tickSpeed, minecraft.field_71441_e.func_72912_H().func_82573_f(), minecraft);
            }
        }

        @SubscribeEvent
        public static void commandRegisterEvent(FMLServerStartingEvent event) {
            LOGGER.debug("BW: \"Server Starting\" Event Starting...");
            BetterWeather.register((CommandDispatcher<CommandSource>)event.getServer().func_195571_aL().func_197054_a());
            LOGGER.info("BW: \"Server Starting\" Event Complete!");
        }
    }
}

