/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather;

import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.SeasonData;
import corgitaco.betterweather.config.json.SeasonConfig;
import corgitaco.betterweather.config.json.overrides.BiomeOverrideJsonHandler;
import corgitaco.betterweather.helper.ViewFrustumGetter;
import corgitaco.betterweather.helper.WeatherViewFrustum;
import corgitaco.betterweather.season.Season;
import corgitaco.betterweather.util.storage.OverrideStorage;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.InputMappings;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BetterWeatherClientUtil {
    private static int configReloadIdx = 0;

    @OnlyIn(value=Dist.CLIENT)
    public static void configReloadKeybind(int key) {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (InputMappings.func_216506_a((long)minecraft.func_228018_at_().func_198092_i(), (int)293) && key == 82) {
            if (configReloadIdx == 0) {
                BetterWeather.loadClientConfigs();
                minecraft.field_71438_f.func_72712_a();
                Season.SubSeason.SeasonClient.stopSpamIDXFoliage = 0;
                Season.SubSeason.SeasonClient.stopSpamIDXGrass = 0;
                Season.SubSeason.SeasonClient.stopSpamIDXSky = 0;
                Season.SubSeason.SeasonClient.stopSpamIDXFog = 0;
                BetterWeatherClientUtil.printDebugMessage("bw.debug.reloadconfig.message", new Object[0]);
                configReloadIdx = 1;
            }
        } else {
            configReloadIdx = 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void printDebugWarning(String message, Object ... args) {
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)new TranslationTextComponent("debug.prefix").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.BOLD})).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(message, args)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void printDebugMessage(String message, Object ... args) {
        Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((ITextComponent)new StringTextComponent("").func_230529_a_((ITextComponent)new TranslationTextComponent("debug.prefix").func_240701_a_(new TextFormatting[]{TextFormatting.YELLOW, TextFormatting.BOLD})).func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent(message, args)));
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void refreshViewFrustum(Minecraft minecraft, int renderDistance) {
        if (!BetterWeather.usingOptifine) {
            ((WeatherViewFrustum)((ViewFrustumGetter)minecraft.field_71438_f).getViewFrustum()).forceRenderDistance(renderDistance, minecraft.field_71439_g.func_226277_ct_(), minecraft.field_71439_g.func_226278_cu_(), minecraft.field_71439_g.func_226281_cx_());
        }
    }

    public static void loadSeasonConfigsClient() {
        if (BetterWeather.useSeasons) {
            Path seasonConfig = BetterWeather.CONFIG_PATH.resolve("betterweather-seasons.json");
            try {
                SeasonConfig.handleBWSeasonsConfig(seasonConfig);
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)"Reading Season Config");
                BetterWeatherClientUtil.printDebugWarning("bw.reload.season.config.fail", seasonConfig.getFileName(), crashReport.func_71505_b().toString());
                BetterWeather.LOGGER.error("\"" + seasonConfig.getFileName() + "\" failed to load because of the following error(s): " + crashReport.func_71502_e() + "\n Using shipped default...");
                Season.SUB_SEASON_MAP = Season.FALLBACK_MAP;
            }
            Season.SUB_SEASON_MAP.forEach((subSeasonName, subSeason) -> {
                Path overrideFilePath = BetterWeather.CONFIG_PATH.resolve("overrides").resolve(subSeasonName + "-override.json");
                if (subSeason.getParentSeason() == SeasonData.SeasonVal.WINTER) {
                    try {
                        BiomeOverrideJsonHandler.handleOverrideJsonConfigs(overrideFilePath, Season.SubSeason.WINTER_OVERRIDE, subSeason);
                    }
                    catch (Exception e) {
                        CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)"Reading Subseason Override Config");
                        BetterWeatherClientUtil.printDebugWarning("bw.reload.seasonoverride.config.fail", overrideFilePath.getFileName(), crashReport.func_71505_b().toString());
                        BetterWeather.LOGGER.error("Override Config: \"" + overrideFilePath.getFileName() + "\" failed to load because of the following error(s): " + crashReport.func_71502_e() + "\n Doing nothing...");
                        subSeason.setCropToMultiplierStorage(new IdentityHashMap<Block, Double>());
                        subSeason.setBiomeToOverrideStorage(new IdentityHashMap<ResourceLocation, OverrideStorage>());
                    }
                } else {
                    try {
                        BiomeOverrideJsonHandler.handleOverrideJsonConfigs(overrideFilePath, new IdentityHashMap<Object, OverrideStorage>(), subSeason);
                    }
                    catch (Exception e) {
                        BetterWeatherClientUtil.printDebugWarning("bw.reloadconfig.fail", overrideFilePath.getFileName(), e.toString());
                        BetterWeather.LOGGER.error("Override Config: \"" + overrideFilePath.getFileName() + "\" failed to load! Doing nothing...");
                        subSeason.setCropToMultiplierStorage(new IdentityHashMap<Block, Double>());
                        subSeason.setBiomeToOverrideStorage(new IdentityHashMap<ResourceLocation, OverrideStorage>());
                    }
                }
            });
        }
    }
}

