/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather;

import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.BetterWeatherClientUtil;
import corgitaco.betterweather.api.SeasonData;
import corgitaco.betterweather.config.json.SeasonConfig;
import corgitaco.betterweather.config.json.overrides.BiomeOverrideJsonHandler;
import corgitaco.betterweather.season.Season;
import corgitaco.betterweather.util.storage.OverrideStorage;
import java.awt.Color;
import java.nio.file.Path;
import java.util.IdentityHashMap;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.command.CommandSource;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public class BetterWeatherUtil {
    public static final Color DEFAULT_RAIN_SKY = new Color(103, 114, 136);
    public static final Color DEFAULT_RAIN_FOG = new Color(89, 100, 142);
    public static final Color DEFAULT_RAIN_CLOUDS = new Color(158, 158, 158);
    public static final Color DEFAULT_THUNDER_SKY = new Color(42, 45, 51);
    public static final Color DEFAULT_THUNDER_FOG = new Color(85, 95, 135);
    public static final Color DEFAULT_THUNDER_CLOUDS = new Color(37, 37, 37);

    public static int parseHexColor(String targetHexColor) {
        if (!targetHexColor.isEmpty()) {
            try {
                return (int)Long.parseLong(targetHexColor.replace("#", "").replace("0x", ""), 16);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        return Integer.MAX_VALUE;
    }

    public static boolean filterRegistryID(ResourceLocation id, Registry<?> registry, String registryTypeName) {
        if (registry.func_148742_b().contains(id)) {
            return true;
        }
        BetterWeather.LOGGER.error("\"" + id.toString() + "\" was not a registryID in the " + registryTypeName + "! Skipping entry...");
        return false;
    }

    public static int transformRainOrThunderTimeToCurrentSeason(int rainOrThunderTime, Season.SubSeason previous, Season.SubSeason current) {
        double previousMultiplier = previous.getWeatherEventChanceMultiplier();
        double currentMultiplier = current.getWeatherEventChanceMultiplier();
        double normalTime = (double)rainOrThunderTime * previousMultiplier;
        return (int)(normalTime * 1.0 / currentMultiplier);
    }

    public static int modifiedColorValue(int original, int target, double blendStrength) {
        return (int)MathHelper.func_219803_d((double)blendStrength, (double)original, (double)target);
    }

    public static Color blendColor(Color original, Color target, double blendStrength) {
        int modifiedRed = BetterWeatherUtil.modifiedColorValue(original.getRed(), target.getRed(), blendStrength);
        int modifiedGreen = BetterWeatherUtil.modifiedColorValue(original.getGreen(), target.getGreen(), blendStrength);
        int modifiedBlue = BetterWeatherUtil.modifiedColorValue(original.getBlue(), target.getBlue(), blendStrength);
        return new Color(modifiedRed, modifiedGreen, modifiedBlue);
    }

    public static Color transformFloatColor(Vector3d floatColor) {
        return new Color((int)(floatColor.func_82615_a() * 255.0), (int)(floatColor.func_82617_b() * 255.0), (int)(floatColor.func_82616_c() * 255.0));
    }

    public static boolean isOverworld(RegistryKey<World> worldKey) {
        return worldKey == World.field_234918_g_;
    }

    public static void loadSeasonConfigsServer(@Nullable CommandSource source) {
        if (BetterWeather.useSeasons) {
            Path seasonConfig = BetterWeather.CONFIG_PATH.resolve("betterweather-seasons.json");
            try {
                SeasonConfig.handleBWSeasonsConfig(seasonConfig);
            }
            catch (Exception e) {
                CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)"Reading Season Config");
                if (source == null) {
                    BetterWeatherClientUtil.printDebugWarning("bw.reload.season.config.fail", seasonConfig.getFileName(), crashReport.func_71505_b().toString());
                }
                if (source != null) {
                    source.func_197030_a((ITextComponent)new TranslationTextComponent("bw.reload.season.config.fail", new Object[]{seasonConfig.getFileName(), crashReport.func_71505_b().toString()}), true);
                }
                BetterWeather.LOGGER.error("\"" + seasonConfig.getFileName() + "\" failed to load because of the following error(s): " + crashReport.func_71502_e() + "\n Using shipped default...");
                Season.SUB_SEASON_MAP = Season.FALLBACK_MAP;
            }
            Season.SUB_SEASON_MAP.forEach((subSeasonName, subSeason) -> {
                Path overrideFilePath = BetterWeather.CONFIG_PATH.resolve("overrides").resolve(subSeasonName + "-override.json");
                if (subSeason.getParentSeason() == SeasonData.SeasonVal.WINTER) {
                    try {
                        BiomeOverrideJsonHandler.handleOverrideJsonConfigs(overrideFilePath, Season.SubSeason.WINTER_OVERRIDE, subSeason);
                    }
                    catch (Exception e) {
                        CrashReport crashReport = CrashReport.func_85055_a((Throwable)e, (String)"Reading Subseason Override Config");
                        if (source != null) {
                            source.func_197030_a((ITextComponent)new TranslationTextComponent("bw.reload.seasonoverride.config.fail", new Object[]{overrideFilePath.getFileName(), crashReport.func_71505_b().toString()}), true);
                        }
                        BetterWeather.LOGGER.error("Override Config: \"" + overrideFilePath.getFileName() + "\" failed to load because of the following error(s): " + crashReport.func_71502_e() + "\n Doing nothing...");
                        subSeason.setCropToMultiplierStorage(new IdentityHashMap<Block, Double>());
                        subSeason.setBiomeToOverrideStorage(new IdentityHashMap<ResourceLocation, OverrideStorage>());
                    }
                } else {
                    try {
                        BiomeOverrideJsonHandler.handleOverrideJsonConfigs(overrideFilePath, new IdentityHashMap<Object, OverrideStorage>(), subSeason);
                    }
                    catch (Exception e) {
                        if (source == null) {
                            BetterWeatherClientUtil.printDebugWarning("bw.reloadconfig.fail", overrideFilePath.getFileName(), e.toString());
                        }
                        if (source != null) {
                            source.func_197030_a((ITextComponent)new TranslationTextComponent("bw.reloadconfig.fail", new Object[]{overrideFilePath.getFileName(), e.toString()}), true);
                        }
                        BetterWeather.LOGGER.error("Override Config: \"" + overrideFilePath.getFileName() + "\" failed to load! Doing nothing...");
                        subSeason.setCropToMultiplierStorage(new IdentityHashMap<Block, Double>());
                        subSeason.setBiomeToOverrideStorage(new IdentityHashMap<ResourceLocation, OverrideStorage>());
                    }
                }
            });
        }
    }
}

