/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.api.weatherevent;

import corgitaco.betterweather.api.weatherevent.BetterWeatherID;
import corgitaco.betterweather.api.weatherevent.SeasonChance;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;

public abstract class WeatherEvent {
    private final BetterWeatherID name;
    private final double defaultChance;
    private final SeasonChance seasonChance;

    public WeatherEvent(BetterWeatherID name, double defaultChance) {
        this(name, defaultChance, new SeasonChance());
    }

    public WeatherEvent(BetterWeatherID name, double defaultChance, SeasonChance seasonChance) {
        this.name = name;
        this.defaultChance = defaultChance;
        this.seasonChance = seasonChance;
    }

    public final BetterWeatherID getID() {
        return this.name;
    }

    public final double getDefaultChance() {
        return this.defaultChance;
    }

    public final SeasonChance getSeasonChance() {
        return this.seasonChance;
    }

    public abstract void worldTick(ServerWorld var1, int var2, long var3);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void clientTick(ClientWorld var1, int var2, long var3, Minecraft var5);

    public float modifyTemperature(float biomeTemp, float modifiedBiomeTemp, double seasonModifier) {
        return (double)modifiedBiomeTemp == Double.MAX_VALUE ? biomeTemp : modifiedBiomeTemp;
    }

    public float modifyHumidity(float biomeHumidity, float modifiedBiomeHumidity, double seasonModifier) {
        return (double)modifiedBiomeHumidity == Double.MAX_VALUE ? biomeHumidity : modifiedBiomeHumidity;
    }

    public void livingEntityUpdate(Entity entity) {
    }

    public boolean weatherParticlesAndSound(ActiveRenderInfo renderInfo, Minecraft mc) {
        return true;
    }

    public void tickLiveChunks(Chunk chunk, ServerWorld world) {
    }

    public boolean fillBlocksWithWater() {
        return false;
    }

    public boolean spawnSnowInFreezingClimates() {
        return false;
    }

    public final TranslationTextComponent successTranslationTextComponent() {
        return new TranslationTextComponent("commands.bw.setweather.success." + this.name.toString().toLowerCase());
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract boolean renderWeather(Minecraft var1, ClientWorld var2, LightTexture var3, int var4, float var5, double var6, double var8, double var10);

    @OnlyIn(value=Dist.CLIENT)
    public boolean disableSkyColor() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Color modifySkyColor(Color biomeColor, Color returnColor, @Nullable Color seasonTargetColor, float rainStrength) {
        return returnColor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Color modifyFogColor(Color biomeColor, Color returnColor, @Nullable Color seasonTargetColor, float rainStrength) {
        return returnColor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Color modifyCloudColor(Color returnColor, float rainStrength) {
        return returnColor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void handleFogDensity(EntityViewRenderEvent.FogDensity event, Minecraft mc) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public Color modifyGrassColor(Color biomeColor, @Nullable Color modifiedColor, @Nullable Color seasonColor) {
        return modifiedColor == null ? biomeColor : modifiedColor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Color modifyFoliageColor(Color biomeColor, @Nullable Color modifiedColor, @Nullable Color seasonColor) {
        return modifiedColor == null ? biomeColor : modifiedColor;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float skyOpacity() {
        return 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float dayLightDarkness() {
        return 1.0f;
    }

    public boolean refreshPlayerRenderer() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int forcedRenderDistance() {
        return Minecraft.func_71410_x().field_71474_y.field_151451_c;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean preventChunkRendererRefreshingWhenOptifineIsPresent() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean drippingLeaves() {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onCommandWeatherChange() {
    }
}

