/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.config.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.SeasonData;
import corgitaco.betterweather.season.Season;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;

public class SeasonConfig {
    public static void handleBWSeasonsConfig(Path path) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.disableHtmlEscaping();
        Gson gson = gsonBuilder.create();
        File CONFIG_FILE = new File(String.valueOf(path));
        if (!CONFIG_FILE.exists()) {
            SeasonConfig.createSeasonJson(path, Season.SEASON_MAP);
        }
        try (FileReader reader = new FileReader(path.toString());){
            Map biomeDataListHolder = (Map)gson.fromJson((Reader)reader, Map.class);
            if (biomeDataListHolder != null) {
                int idx;
                TreeMap<String, Season> stringSeasonMap = new TreeMap<String, Season>();
                for (idx = 0; idx < SeasonData.SeasonVal.values().length; ++idx) {
                    String seasonName = SeasonData.SeasonVal.values()[idx].toString();
                    Season object = (Season)new Gson().fromJson(new Gson().toJson((Object)((LinkedTreeMap)biomeDataListHolder.get(seasonName))), Season.class);
                    stringSeasonMap.put(seasonName, object);
                }
                for (idx = 0; idx < SeasonData.SubSeasonVal.values().length; ++idx) {
                    String subSeasonName = SeasonData.SubSeasonVal.values()[idx].toString();
                    for (int idx2 = 0; idx2 < SeasonData.SeasonVal.values().length; ++idx2) {
                        String seasonName = SeasonData.SeasonVal.values()[idx2].toString();
                        if (subSeasonName.contains(seasonName)) {
                            if (subSeasonName.contains("START")) {
                                ((Season)stringSeasonMap.get(seasonName)).getStart().setSubSeasonVal(SeasonData.SubSeasonVal.valueOf(subSeasonName));
                                ((Season)stringSeasonMap.get(seasonName)).getStart().setParentSeason(SeasonData.SeasonVal.valueOf(seasonName));
                                Season.SUB_SEASON_MAP.put(subSeasonName, ((Season)stringSeasonMap.get(seasonName)).getStart());
                            } else if (subSeasonName.contains("MID")) {
                                ((Season)stringSeasonMap.get(seasonName)).getMid().setSubSeasonVal(SeasonData.SubSeasonVal.valueOf(subSeasonName));
                                ((Season)stringSeasonMap.get(seasonName)).getMid().setParentSeason(SeasonData.SeasonVal.valueOf(seasonName));
                                Season.SUB_SEASON_MAP.put(subSeasonName, ((Season)stringSeasonMap.get(seasonName)).getMid());
                            } else {
                                ((Season)stringSeasonMap.get(seasonName)).getEnd().setSubSeasonVal(SeasonData.SubSeasonVal.valueOf(subSeasonName));
                                ((Season)stringSeasonMap.get(seasonName)).getEnd().setParentSeason(SeasonData.SeasonVal.valueOf(seasonName));
                                Season.SUB_SEASON_MAP.put(subSeasonName, ((Season)stringSeasonMap.get(seasonName)).getEnd());
                            }
                        }
                        Season.SubSeason subSeason = Season.SUB_SEASON_MAP.get(subSeasonName);
                        subSeason.getClient().parseHexColors();
                        subSeason.processInfo();
                    }
                }
                Season.SEASON_MAP = stringSeasonMap;
            } else {
                BetterWeather.LOGGER.error("betterweather-seasons.json could not be read");
            }
        }
        catch (IOException e) {
            BetterWeather.LOGGER.error("betterweather-seasons.json could not be read");
        }
    }

    public static void createSeasonJson(Path path, Map<String, Season> seasonStringMap) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.disableHtmlEscaping();
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson(seasonStringMap);
        try {
            Files.write(path, jsonString.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            BetterWeather.LOGGER.error("betterweather-rivers.json could not be created");
        }
    }
}

