/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.season.client;

import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.BetterWeatherUtil;
import corgitaco.betterweather.api.weatherevent.WeatherData;
import corgitaco.betterweather.season.Season;
import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class BiomeColorCalculator {
    public static Color modifyBiomeColor(ColorType colorType, Color originalColorValue, Season.SubSeason subSeason, Biome biome) {
        double blendStrength;
        Color target;
        Color fallbackColor = BiomeColorCalculator.modifyColorForWeatherEvent(colorType, originalColorValue, originalColorValue, null);
        Minecraft mc = Minecraft.func_71410_x();
        if (!BetterWeatherUtil.isOverworld((RegistryKey<World>)mc.field_71441_e.func_234923_W_())) {
            return originalColorValue;
        }
        if (!BetterWeather.useSeasons) {
            return fallbackColor;
        }
        if (mc.field_71441_e == null) {
            return fallbackColor;
        }
        int red = originalColorValue.getRed();
        int green = originalColorValue.getGreen();
        int blue = originalColorValue.getBlue();
        DynamicRegistries dynamicRegistries = mc.field_71441_e.func_241828_r();
        ResourceLocation biomeKey = dynamicRegistries.func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
        if (biomeKey == null) {
            return fallbackColor;
        }
        switch (colorType) {
            case GRASS: {
                int targetGrassColor = subSeason.getTargetGrassColor(biomeKey, false);
                if (targetGrassColor == Integer.MAX_VALUE) {
                    return fallbackColor;
                }
                target = new Color(targetGrassColor);
                blendStrength = subSeason.getGrassColorBlendStrength(biomeKey, false);
                break;
            }
            case FOLIAGE: {
                int targetFoliageColor = subSeason.getTargetFoliageColor(biomeKey, false);
                if (targetFoliageColor == Integer.MAX_VALUE) {
                    return fallbackColor;
                }
                target = new Color(targetFoliageColor);
                blendStrength = subSeason.getFoliageColorBlendStrength(biomeKey, false);
                break;
            }
            case FOG: {
                int targetFogColor = subSeason.getTargetFogColor(biomeKey, false);
                if (targetFogColor == Integer.MAX_VALUE) {
                    return fallbackColor;
                }
                target = new Color(targetFogColor);
                blendStrength = subSeason.getFogColorBlendStrength(biomeKey, false);
                break;
            }
            default: {
                int targetSkyColor = subSeason.getTargetSkyColor(biomeKey, false);
                if (targetSkyColor == Integer.MAX_VALUE) {
                    return fallbackColor;
                }
                target = new Color(targetSkyColor);
                blendStrength = subSeason.getSkyColorBlendStrength(biomeKey, false);
            }
        }
        red = BiomeColorCalculator.modifiedColorValue(red, target.getRed(), blendStrength);
        green = BiomeColorCalculator.modifiedColorValue(green, target.getGreen(), blendStrength);
        blue = BiomeColorCalculator.modifiedColorValue(blue, target.getBlue(), blendStrength);
        int clampedRed = MathHelper.func_76125_a((int)red, (int)0, (int)255);
        int clampedGreen = MathHelper.func_76125_a((int)green, (int)0, (int)255);
        int clampedBlue = MathHelper.func_76125_a((int)blue, (int)0, (int)255);
        Color modifiedColor = new Color(clampedRed, clampedGreen, clampedBlue);
        return BiomeColorCalculator.modifyColorForWeatherEvent(colorType, originalColorValue, modifiedColor, target);
    }

    public static Color modifyColorForWeatherEvent(ColorType type, Color originalBiomeColor, Color returnColor, @Nullable Color seasonTargetColor) {
        Minecraft instance = Minecraft.func_71410_x();
        float partialTicks = instance.func_147113_T() ? instance.field_193996_ah : instance.field_71428_T.field_194147_b;
        switch (type) {
            case GRASS: {
                return WeatherData.currentWeatherEvent.modifyGrassColor(originalBiomeColor, returnColor, seasonTargetColor);
            }
            case FOLIAGE: {
                return WeatherData.currentWeatherEvent.modifyFoliageColor(originalBiomeColor, returnColor, seasonTargetColor);
            }
            case SKY: {
                return WeatherData.currentWeatherEvent.modifySkyColor(originalBiomeColor, returnColor, seasonTargetColor, instance.field_71441_e.func_72867_j(partialTicks));
            }
            case FOG: {
                return WeatherData.currentWeatherEvent.modifyFogColor(originalBiomeColor, returnColor, seasonTargetColor, instance.field_71441_e.func_72867_j(partialTicks));
            }
        }
        return originalBiomeColor;
    }

    private static int modifiedColorValue(int original, int target, double blendStrength) {
        return (int)MathHelper.func_219803_d((double)blendStrength, (double)original, (double)target);
    }

    public static enum ColorType {
        FOLIAGE,
        GRASS,
        SKY,
        FOG;

    }
}

