/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.weatherevent.weatherevents;

import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.BetterWeatherUtil;
import corgitaco.betterweather.api.weatherevent.BetterWeatherID;
import corgitaco.betterweather.api.weatherevent.WeatherEvent;
import corgitaco.betterweather.config.BetterWeatherConfig;
import corgitaco.betterweather.config.BetterWeatherConfigClient;
import corgitaco.betterweather.datastorage.BetterWeatherEventData;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.settings.ParticleStatus;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.profiler.IProfiler;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;

public class AcidRain
extends WeatherEvent {
    public static final ForgeRegistry<Block> blockRegistry = (ForgeRegistry)ForgeRegistries.BLOCKS;
    public static final ResourceLocation RAIN_TEXTURE = new ResourceLocation("textures/environment/rain.png");
    public static final ResourceLocation ACID_RAIN_TEXTURE = new ResourceLocation("betterweather", "textures/environment/acid_rain.png");
    static Block block = (Block)blockRegistry.getRaw(new ResourceLocation((String)BetterWeatherConfig.blockToChangeFromGrass.get()));

    public AcidRain() {
        super(new BetterWeatherID("betterweather", "ACID_RAIN"), 0.25);
    }

    public static void addAcidRainParticles(ActiveRenderInfo activeRenderInfoIn, Minecraft mc, WorldRenderer worldRenderer) {
        float f = mc.field_71441_e.func_72867_j(1.0f) / (Minecraft.func_71375_t() ? 1.0f : 2.0f);
        if (!(f <= 0.0f)) {
            Random random = new Random((long)worldRenderer.field_72773_u * 312987231L);
            ClientWorld iworldreader = mc.field_71441_e;
            BlockPos blockpos = new BlockPos(activeRenderInfoIn.func_216785_c());
            BlockPos blockpos1 = null;
            int i = (int)(100.0f * f * f) / (mc.field_71474_y.field_74362_aa == ParticleStatus.DECREASED ? 2 : 1);
            for (int j = 0; j < i; ++j) {
                int k = random.nextInt(21) - 10;
                int l = random.nextInt(21) - 10;
                BlockPos blockpos2 = iworldreader.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos.func_177982_a(k, 0, l)).func_177977_b();
                Biome biome = iworldreader.func_226691_t_(blockpos2);
                if (blockpos2.func_177956_o() <= 0 || blockpos2.func_177956_o() > blockpos.func_177956_o() + 10 || blockpos2.func_177956_o() < blockpos.func_177956_o() - 10 || biome.func_201851_b() != Biome.RainType.RAIN || !(biome.func_225486_c(blockpos2) >= 0.15f)) continue;
                blockpos1 = blockpos2;
                if (mc.field_71474_y.field_74362_aa == ParticleStatus.MINIMAL) break;
                double d0 = random.nextDouble();
                double d1 = random.nextDouble();
                BlockState blockstate = iworldreader.func_180495_p(blockpos2);
                FluidState fluidstate = iworldreader.func_204610_c(blockpos2);
                VoxelShape voxelshape = blockstate.func_196952_d((IBlockReader)iworldreader, blockpos2);
                double d2 = voxelshape.func_197760_b(Direction.Axis.Y, d0, d1);
                double d3 = fluidstate.func_215679_a((IBlockReader)iworldreader, blockpos2);
                double d4 = Math.max(d2, d3);
                BasicParticleType iparticledata = ParticleTypes.field_197601_L;
                mc.field_71441_e.func_195594_a((IParticleData)iparticledata, (double)blockpos2.func_177958_n() + d0, (double)blockpos2.func_177956_o() + d4, (double)blockpos2.func_177952_p() + d1, 0.0, 0.0, 0.0);
            }
            if (blockpos1 != null && random.nextInt(3) < worldRenderer.field_228410_aj_++) {
                worldRenderer.field_228410_aj_ = 0;
                if (blockpos1.func_177956_o() > blockpos.func_177956_o() + 1 && iworldreader.func_205770_a(Heightmap.Type.MOTION_BLOCKING, blockpos).func_177956_o() > MathHelper.func_76141_d((float)blockpos.func_177956_o())) {
                    mc.field_71441_e.func_184156_a(blockpos1, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f, 0.5f, false);
                } else {
                    mc.field_71441_e.func_184156_a(blockpos1, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f, 1.0f, false);
                }
            }
        }
    }

    public static void acidRainEvent(Chunk chunk, ServerWorld world, long worldTime) {
        ChunkPos chunkpos = chunk.func_76632_l();
        int chunkXStart = chunkpos.func_180334_c();
        int chunkZStart = chunkpos.func_180333_d();
        IProfiler iprofiler = world.func_217381_Z();
        iprofiler.func_76320_a("acidrain");
        BlockPos blockpos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, world.func_217383_a(chunkXStart, 0, chunkZStart, 15));
        if (world.isAreaLoaded(blockpos, 1) && world.func_72912_H().func_76059_o() && worldTime % (long)((Integer)BetterWeatherConfig.tickBlockDestroySpeed.get()).intValue() == 0L && ((Boolean)BetterWeatherConfig.destroyBlocks.get()).booleanValue() && world.func_226691_t_(blockpos).func_201851_b() == Biome.RainType.RAIN) {
            if (BetterWeatherConfig.destroyGrass) {
                if (block == null) {
                    BetterWeather.LOGGER.error("The block replacing grass, registry location was incorrect. You put: " + (String)BetterWeatherConfig.blockToChangeFromGrass.get() + "\n Reverting to dirt!");
                    block = Blocks.field_150346_d;
                }
                if (world.func_180495_p(blockpos.func_177977_b()).func_177230_c() == Blocks.field_196658_i) {
                    world.func_175656_a(blockpos.func_177977_b(), block.func_176223_P());
                }
            }
            if (BetterWeatherConfig.destroyPlants && (world.func_180495_p(blockpos).func_185904_a() == Material.field_151585_k || world.func_180495_p(blockpos).func_185904_a() == Material.field_151582_l && !BetterWeatherConfig.blocksToNotDestroyList.contains(world.func_180495_p(blockpos).func_177230_c()))) {
                world.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
            }
            if (BetterWeatherConfig.destroyLeaves && world.func_180495_p(blockpos.func_177977_b()).func_177230_c().func_203417_a((ITag)BlockTags.field_206952_E) && !BetterWeatherConfig.blocksToNotDestroyList.contains(world.func_180495_p(blockpos.func_177977_b()).func_177230_c())) {
                world.func_175656_a(blockpos.func_177977_b(), Blocks.field_150350_a.func_176223_P());
            }
            if (BetterWeatherConfig.destroyCrops && world.func_180495_p(blockpos).func_177230_c().func_203417_a((ITag)BlockTags.field_226152_ab_) && !BetterWeatherConfig.blocksToNotDestroyList.contains(world.func_180495_p(blockpos).func_177230_c())) {
                world.func_175656_a(blockpos, Blocks.field_150350_a.func_176223_P());
            }
        }
        iprofiler.func_76319_b();
    }

    @Override
    public void worldTick(ServerWorld world, int tickSpeed, long worldTime) {
    }

    @Override
    public boolean renderWeather(Minecraft mc, ClientWorld world, LightTexture lightTexture, int ticks, float partialTicks, double x, double y, double z) {
        return false;
    }

    @Override
    public void livingEntityUpdate(Entity entity) {
        BlockPos entityPos;
        World world;
        if (BetterWeatherConfig.damageMonsters && entity.getClassification(true) == EntityClassification.MONSTER && (world = entity.field_70170_p).func_226660_f_(entityPos = new BlockPos(entity.func_213303_ch())) && world.func_82737_E() % (long)((Integer)BetterWeatherConfig.hurtEntityTickSpeed.get()).intValue() == 0L) {
            entity.func_70097_a(DamageSource.field_76377_j, 0.5f);
        }
        if (BetterWeatherConfig.damageAnimals && (entity.getClassification(true) == EntityClassification.CREATURE || entity.getClassification(true) == EntityClassification.AMBIENT) && (world = entity.field_70170_p).func_226660_f_(entityPos = new BlockPos(entity.func_213303_ch())) && world.func_82737_E() % (long)((Integer)BetterWeatherConfig.hurtEntityTickSpeed.get()).intValue() == 0L) {
            entity.func_70097_a(DamageSource.field_76377_j, ((Double)BetterWeatherConfig.hurtEntityDamage.get()).floatValue());
        }
        if (BetterWeatherConfig.damagePlayer && entity instanceof PlayerEntity && (world = entity.field_70170_p).func_226660_f_(entityPos = new BlockPos(entity.func_213303_ch())) && BetterWeatherEventData.get((IWorld)world).isAcidRain() && world.func_72912_H().func_76059_o() && world.func_82737_E() % (long)((Integer)BetterWeatherConfig.hurtEntityTickSpeed.get()).intValue() == 0L) {
            entity.func_70097_a(DamageSource.field_76377_j, 0.5f);
        }
    }

    @Override
    public void clientTick(ClientWorld world, int tickSpeed, long worldTime, Minecraft mc) {
        if (WorldRenderer.field_228413_h_ != ACID_RAIN_TEXTURE) {
            WorldRenderer.field_228413_h_ = ACID_RAIN_TEXTURE;
        }
    }

    @Override
    public boolean weatherParticlesAndSound(ActiveRenderInfo renderInfo, Minecraft mc) {
        if (!((Boolean)BetterWeatherConfigClient.removeSmokeParticles.get()).booleanValue()) {
            AcidRain.addAcidRainParticles(renderInfo, mc, mc.field_71438_f);
        }
        return false;
    }

    @Override
    public Color modifySkyColor(Color biomeColor, Color returnColor, @Nullable Color seasonTargetColor, float rainStrength) {
        return BetterWeatherUtil.blendColor(returnColor, BetterWeatherUtil.DEFAULT_RAIN_SKY, rainStrength);
    }

    @Override
    public Color modifyCloudColor(Color returnColor, float rainStrength) {
        return BetterWeatherUtil.blendColor(returnColor, BetterWeatherUtil.DEFAULT_RAIN_CLOUDS, rainStrength);
    }

    @Override
    public Color modifyFogColor(Color biomeColor, Color returnColor, @Nullable Color seasonTargetColor, float rainStrength) {
        return BetterWeatherUtil.blendColor(returnColor, BetterWeatherUtil.DEFAULT_RAIN_FOG, rainStrength);
    }

    @Override
    public boolean fillBlocksWithWater() {
        return true;
    }

    @Override
    public boolean spawnSnowInFreezingClimates() {
        return true;
    }

    @Override
    public void tickLiveChunks(Chunk chunk, ServerWorld world) {
        AcidRain.acidRainEvent(chunk, world, world.func_72912_H().func_82573_f());
    }
}

