/*
 * Decompiled with CFR 0.152.
 */
package com.gjhi.tinkersinnovation;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class TinkersInnovationConfig {
    public static final CommonConfig COMMON;
    public static ForgeConfigSpec config;

    static {
        Pair pair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)pair.getLeft();
        config = (ForgeConfigSpec)pair.getRight();
    }

    public static class CommonConfig {
        public final OreConfig voidcrystalOre;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Void Crystal Ore Worldgen").push("void_crystal_ore");
            this.voidcrystalOre = new VoidCrystalOreConfig(builder);
            builder.pop();
        }
    }

    public static class VoidCrystalOreConfig
    extends OreConfig {
        public VoidCrystalOreConfig(ForgeConfigSpec.Builder builder) {
            super(builder);
            this.enabled = builder.worldRestart().comment("Enable/Disable Void Crystal ore").define("VoidCrystalOreEnabled", true);
            this.minY = builder.comment("Min Y level").defineInRange("minY", -64, -64, -20);
            this.maxY = builder.comment("Max Y Level").defineInRange("maxY", -54, -60, 0);
            this.count = builder.comment("Ore vein count").defineInRange("veinCount", 20, 1, 40);
            this.size = builder.comment("Ore vein size").defineInRange("veinSize", 3, 1, 40);
        }
    }

    public static class OreConfig {
        public ForgeConfigSpec.BooleanValue enabled;
        public ForgeConfigSpec.IntValue minY;
        public ForgeConfigSpec.IntValue maxY;
        public ForgeConfigSpec.IntValue count;
        public ForgeConfigSpec.IntValue size;

        public OreConfig(ForgeConfigSpec.Builder builder) {
        }

        public boolean isEnabled() {
            return (Boolean)this.enabled.get();
        }

        public int getCount() {
            return (Integer)this.count.get();
        }

        public int getSize() {
            return (Integer)this.size.get();
        }

        public int getMaxY() {
            return (Integer)this.maxY.get();
        }

        public int getMinY() {
            return (Integer)this.minY.get();
        }
    }
}

