#version 120

//go to line 96 for changing sunlight/ambient color balance

varying vec4 texcoord;
varying vec3 lightVector;
varying vec3 sunlight_color;
varying vec3 ambient_color;
varying float handItemLight;

uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform int worldTime;
uniform int heldItemId;
uniform int heldBlockLightValue;
uniform float rainStrength;
uniform float wetness;


	////////////////////sunlight color////////////////////
	////////////////////sunlight color////////////////////
	////////////////////sunlight color////////////////////
	const ivec4 ToD[25] = ivec4[25](ivec4(0,5,8,15), //hour,r,g,b
							ivec4(1,0,8,11),
							ivec4(2,0,8,12),
							ivec4(3,0,8,12),
							ivec4(4,0,8,15),
							ivec4(5,2,12,19),
							ivec4(6,150,75,0),
							ivec4(7,150,75,20),
							ivec4(8,175,100,60),
							ivec4(9,240,175,140),
							ivec4(10,240,240,200),
							ivec4(11,240,240,160),
							ivec4(12,240,240,240),
							ivec4(13,240,240,240),
							ivec4(14,240,240,240),
							ivec4(15,240,240,240),
							ivec4(16,240,200,125),
							ivec4(17,240,100,20),
							ivec4(18,110,77,10),
							ivec4(19,0,20,35),
							ivec4(20,0,15,30),
							ivec4(21,0,8,15),
							ivec4(22,0,8,12),
							ivec4(23,0,8,12),
							ivec4(24,0,8,11));

	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	const ivec4 ToD2[25] = ivec4[25](ivec4(0,10,20,45), //hour,r,g,b
							ivec4(1,0,5,15),
							ivec4(2,0,5,17),
							ivec4(3,0,20,45),
							ivec4(4,10,20,45),
							ivec4(5,15,30,50),
							ivec4(6,160,90,0),
							ivec4(7,190,130,40),
							ivec4(8,220,160,90),
							ivec4(9,240,200,150),
							ivec4(10,240,240,240),
							ivec4(11,240,240,240),
							ivec4(12,240,240,240),
							ivec4(13,240,240,240),
							ivec4(14,240,240,240),
							ivec4(15,240,230,210),
							ivec4(16,220,180,120),
							ivec4(17,160,40,0),
							ivec4(18,120,60,20),
							ivec4(19,20,40,60),
							ivec4(20,10,20,45),
							ivec4(21,5,15,30),
							ivec4(22,0,8,30),
							ivec4(23,0,5,17),
							ivec4(24,0,5,15));

//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
void main() {
	
	gl_Position = ftransform();
	
	texcoord = gl_MultiTexCoord0;

	if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	}
	
	else {
		lightVector = normalize(moonPosition);
	}

	handItemLight = 0.0;
	if (heldItemId == 50) {
		// torch
		handItemLight = 0.5;
	}
	
	else if (heldItemId == 76 || heldItemId == 94) {
		// active redstone torch / redstone repeater
		handItemLight = 0.1;
	}
	
	else if (heldItemId == 89) {
		// lightstone
		handItemLight = 0.6;
	}
	
	else if (heldItemId == 10 || heldItemId == 11 || heldItemId == 51) {
		// lava / lava / fire
		handItemLight = 0.5;
	}
	
	else if (heldItemId == 91) {
		// jack-o-lantern
		handItemLight = 0.6;
	}
	
	
	else if (heldItemId == 327) {
		handItemLight = 0.2;
	}

	

	float hour = worldTime/1000.0+6.0;
	if (hour > 24.0) hour = hour - 24.0;

							
	ivec4 temp = ToD[int(floor(hour))];
	ivec4 temp2 = ToD[int(floor(hour)) + 1];
	
	sunlight_color = mix(vec3(temp.yzw),vec3(temp2.yzw),(hour-float(temp.x))/float(temp2.x-temp.x))/255.0f;
	
	

							
	ivec4 tempa = ToD2[int(floor(hour))];
	ivec4 tempa2 = ToD2[int(floor(hour)) + 1];
	
	ambient_color = mix(vec3(tempa.yzw),vec3(tempa2.yzw),(hour-float(tempa.x))/float(tempa2.x-tempa.x))/255.0f;
	
	vec3 ambient_color_rain = vec3(0.2, 0.2, 0.2); //rain

	//ambient_color.g *= 1.2;
	ambient_color = sqrt(pow(mix(ambient_color, ambient_color_rain, rainStrength*0.75),vec3(2.0))*2.0*ambient_color); //rain
	
}
