#version 120

uniform sampler2D gcolor;
uniform sampler2D gdepth;
uniform sampler2D gnormal;
uniform sampler2D gaux1; // red is our motion blur mask. if red == 1, don't blur

varying vec4 texcoord;

uniform float near;
uniform float far;

uniform float viewWidth;
uniform float viewHeight;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;

uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

void main() {
	vec4 color  = texture2D(gcolor, texcoord.st);
	vec4 normal = texture2D(gnormal, texcoord.st);
	vec4 depth  = texture2D(gdepth, texcoord.st);
	vec4 aux1   = texture2D(gaux1, texcoord.st);
	
	gl_FragData[0] = color;
	gl_FragData[1] = depth;
	gl_FragData[2] = normal;
	gl_FragData[4] = aux1;
	
	if (aux1.r > 0.5 || depth.x > 0.9999999) {
		gl_FragData[3] = vec4(color.rgb, 1.0);
		return;
	}
	
	vec4 currentPosition = vec4(texcoord.x * 2.0 - 1.0, texcoord.y * 2.0 - 1.0, 2.0 * depth.x - 1.0, 1.0);
	
	vec4 fragposition = gbufferProjectionInverse * currentPosition;
	fragposition = gbufferModelViewInverse * fragposition;
	fragposition /= fragposition.w;
	fragposition.xyz += cameraPosition;
	
	vec4 previousPosition = fragposition;
	previousPosition.xyz -= previousCameraPosition;
	previousPosition = gbufferPreviousModelView * previousPosition;
	previousPosition = gbufferPreviousProjection * previousPosition;
	previousPosition /= previousPosition.w;

	vec2 velocity = (currentPosition - previousPosition).st * 0.1;

	int samples = 1;

	vec2 coord = texcoord.st + velocity;
	for (int i = 0; i < 8; ++i, coord += velocity) {
		if (coord.s > 1.0 || coord.t > 1.0 || coord.s < 0.0 || coord.t < 0.0) {
			break;
		}
		if (texture2D(gaux1, coord).r < 0.5) {
			color += texture2D(gcolor, coord);
			++samples;
		}
	}

	gl_FragData[3] = vec4(color.rgb / samples, 1.0);
}
