#version 120

/* DRAWBUFFERS:0124 */

#define POM
#define POM_MAP_RES 128.0
#define POM_DEPTH (1.0/16.0)

/* Here, intervalMult might need to be tweaked per texture pack.  
   The first two numbers determine how many samples are taken per fragment.  They should always be the equal to eachother.
   The third number divided by one of the first two numbers is inversely proportional to the range of the height-map. */
const vec3 intervalMult = vec3(1.0, 1.0, 1.0/POM_DEPTH)/POM_MAP_RES * 1.0; 
const float MAX_OCCLUSION_DISTANCE = 32.0;
const float MIX_OCCLUSION_DISTANCE = 28.0;
const int   MAX_OCCLUSION_POINTS   = 16;

uniform sampler2D texture;
uniform sampler2D lightmap;
uniform sampler2D normals;
uniform sampler2D specular;

varying vec4 color;
varying vec2 lmcoord;

varying vec2 vtexcoordadd;
varying vec2 vtexcoordmul;
varying vec2 vtexcoord;

varying vec3 viewVector;
varying vec3 normal;
varying vec3 tangent;
varying vec3 binormal;

varying float distance;

const int GL_LINEAR = 9729;
const int GL_EXP = 2048;

uniform int fogMode;
uniform float wetness;

const float mincoord = 1.0/1024.0;
const float maxcoord = 1.0-mincoord;

vec4 readTexture(in vec2 coord)
{
	return texture2D(texture,fract(coord)*vtexcoordmul+vtexcoordadd);
}

vec4 readNormal(in vec2 coord)
{
	return texture2D(normals,fract(coord)*vtexcoordmul+vtexcoordadd);
}

void main() {
	//gl_FragData[1] = vec4(vec3(gl_FragCoord.z), 1.0);

	vec3 ambient = texture2D(lightmap, vec2(lmcoord.s,0.5/16.)).rgb + texture2D(lightmap, vec2(0.5/16., lmcoord.t)).rgb * 0.6;

	vec2 adjustedTexCoord;
#ifdef POM
	if (distance <= MAX_OCCLUSION_DISTANCE && viewVector.z < 0.0) 
	{
		vec3 interval = viewVector * intervalMult;
		vec3 coord = vec3(vtexcoord.st, 1.0);
		for (int loopCount = 0; 
				(loopCount < MAX_OCCLUSION_POINTS) && (readNormal(coord.st).a < coord.z);
				++loopCount) {
			coord = coord+interval;
		}
		// Don't wrap around top of tall grass/flower
		if (coord.t < mincoord) {
			if (readTexture(vec2(coord.s,mincoord)).a == 0.0) {
				coord.t = mincoord;
				discard;
			}
		}
		coord.st = mix(coord.st, vtexcoord.st, max(distance-MIX_OCCLUSION_DISTANCE,0.0)/(MAX_OCCLUSION_DISTANCE-MIX_OCCLUSION_DISTANCE));
		adjustedTexCoord = fract(coord.st)*vtexcoordmul+vtexcoordadd;
	}
	else
	{
		adjustedTexCoord = vtexcoord*vtexcoordmul+vtexcoordadd;
	}
#else
		adjustedTexCoord = vtexcoord*vtexcoordmul+vtexcoordadd;
#endif

	vec4 diffuse = texture2D(texture, adjustedTexCoord.st) * color;
	
	vec4 texSpecular = texture2D(specular, adjustedTexCoord.st);
	vec3 bump = texture2D(normals, adjustedTexCoord.st).xyz * 2.0 - 1.0;

	gl_FragData[0] = diffuse;
	gl_FragData[3] = vec4(texSpecular.b*diffuse.rgb + vec3(texSpecular.r) + vec3(texSpecular.g)*wetness*max(lmcoord.t-(14.5/16.0),0.0), texSpecular.a);

	mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
                          tangent.y, binormal.y, normal.y,
                          tangent.z, binormal.z, normal.z);

	gl_FragData[2] = vec4(bump * tbnMatrix * 0.5 + 0.5, 1.0);


	float fogFactor; // 0.0 = full fog.  1.0 = no fog.
	if (fogMode == GL_EXP) {
		fogFactor = clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0);
	} else if (fogMode == GL_LINEAR) {
		fogFactor = 1.0 - clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0);
	} else {
		fogFactor = 1.0;
	}
	gl_FragData[1] = vec4(ambient, fogFactor);
}
