#version 120

uniform float rainStrength;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

attribute vec4 mc_Entity;
attribute vec4 mc_midTexCoord;

// entity  8 = flowing water. 9 = still water. 79 = ice.

varying vec4 color;
varying vec2 lmcoord;
varying vec2 vtexcoordadd;
varying vec2 vtexcoordmul;
varying vec2 vtexcoord;

varying vec3 viewVector;
varying vec3 normal;
varying vec3 tangent;
varying vec3 binormal;

varying float distance;

const float PI = 3.1415927;

void main() {
	vec2 texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).st;
	vec2 midcoord = (gl_TextureMatrix[0] * mc_midTexCoord).st;
	vec2 texcoordminusmid = texcoord-midcoord;
	vtexcoordmul  = abs(texcoordminusmid)*2;
	vtexcoordadd  = min(texcoord,midcoord-texcoordminusmid);
	vtexcoord     = sign(texcoordminusmid)*0.5+0.5;

	lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).st;

	color = gl_Color;

	vec4 position = gl_ModelViewMatrix * gl_Vertex;
	//vec4 viewpos = gl_ModelViewMatrix * gl_Vertex;

	/* un-rotate */
	vec4 viewpos = gbufferModelViewInverse * position;

	vec3 worldpos = viewpos.xyz + cameraPosition;

	if(mc_Entity.x == 8.0 || mc_Entity.x == 9.0) { 
		vec3 pos = worldpos;
	    float fy = fract(pos.y + 0.001);
	    if (fy > 0.002)
		{
		    /* animate */
		float wave = 0.05 * sin(2*PI/4*frameTimeCounter + 2*PI*2/16*pos.x + 2*PI*5/16*pos.z)
				   + 0.05 * sin(2*PI/3*frameTimeCounter - 2*PI*3/16*pos.x + 2*PI*4/16*pos.z);
			viewpos.y += clamp(wave, -fy, 1.0-fy);
		}
	}

	/* re-rotate */
	vec4 viewVertex = gbufferModelView * viewpos;

	distance = length(viewVertex);

	/* projectify */
	gl_Position = gl_ProjectionMatrix * viewVertex;

	//gl_FogFragCoord = gl_Position.z;
	gl_FogFragCoord = distance;

	normal = normalize(gl_NormalMatrix * gl_Normal);

	if (gl_Normal.y > 0.5) {
		//  0.0,  1.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
	} else if (gl_Normal.x > 0.5) {
		//  1.0,  0.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0, -1.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	} else if (gl_Normal.x < -0.5) {
		// -1.0,  0.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	} else if (gl_Normal.z > 0.5) {
		//  0.0,  0.0,  1.0
		tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	} else if (gl_Normal.z < -0.5) {
		//  0.0,  0.0, -1.0
		tangent  = normalize(gl_NormalMatrix * vec3(-1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0, -1.0,  0.0));
	} else if (gl_Normal.y < -0.5) {
		//  0.0, -1.0,  0.0
		tangent  = normalize(gl_NormalMatrix * vec3( 1.0,  0.0,  0.0));
		binormal = normalize(gl_NormalMatrix * vec3( 0.0,  0.0,  1.0));
	}

	mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
                          tangent.y, binormal.y, normal.y,
                          tangent.z, binormal.z, normal.z);
	
	viewVector = normalize(tbnMatrix * viewVertex.xyz);
}
