#version 120

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 lightVector;
varying vec3 ambient_color;

uniform int worldTime;
uniform float rainStrength;
uniform vec3 sunPosition;
uniform vec3 moonPosition;


   ////////////////////sun-moon color////////////////////////
   ////////////////////sun-moon color////////////////////////
   ////////////////////sun-moon color////////////////////////
	const ivec4 ToD[25] = ivec4[25](ivec4(0,10,15,30), //hour,r,g,b
							ivec4(1,0,15,30),
							ivec4(2,0,15,30),
							ivec4(3,0,15,30),
							ivec4(4,10,15,30),
							ivec4(5,10,15,30),
							ivec4(6,255,60,0),
							ivec4(7,255,120,20),
							ivec4(8,255,200,80),
							ivec4(9,255,240,130),
							ivec4(10,255,255,180),
							ivec4(11,255,255,255),
							ivec4(12,255,255,255),
							ivec4(13,255,255,255),
							ivec4(14,255,255,255),
							ivec4(15,255,255,180),
							ivec4(16,255,220,120),
							ivec4(17,255,80,0),
							ivec4(18,170,90,10),
							ivec4(19,30,50,96),
							ivec4(20,10,15,30),
							ivec4(21,10,15,30),
							ivec4(22,0,15,30),
							ivec4(23,0,15,30),
							ivec4(24,0,15,30));
							
							
	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	////////////////////ambient color////////////////////
	const ivec4 ToD2[25] = ivec4[25](ivec4(0,10,20,45), //hour,r,g,b
							ivec4(1,0,15,45),
							ivec4(2,0,17,45),
							ivec4(3,0,20,45),
							ivec4(4,10,20,45),
							ivec4(5,15,25,50),
							ivec4(6,40,80,140),
							ivec4(7,55,110,180),
							ivec4(8,65,150,220),
							ivec4(9,72,175,260),
							ivec4(10,80,200,300),
							ivec4(11,100,220,340),
							ivec4(12,100,220,340),
							ivec4(13,100,220,340),
							ivec4(14,100,220,340),
							ivec4(15,100,200,300),
							ivec4(16,120,120,250),
							ivec4(17,30,35,100),
							ivec4(18,100,60,0),
							ivec4(19,5,30,60),
							ivec4(20,10,20,45),
							ivec4(21,10,20,45),
							ivec4(22,0,20,45),
							ivec4(23,0,17,45),
							ivec4(24,0,15,45));
							
							
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////
//////////////////////////////main//////////////////////////////

void main() {
	
		if (worldTime < 12700 || worldTime > 23250) {
		lightVector = normalize(sunPosition);
	}
	
	else {
		lightVector = normalize(moonPosition);
	}
	
	gl_Position = ftransform();
	
	texcoord = gl_MultiTexCoord0;
	
	//sunlight color
	float hour = worldTime/1000.0+6.0;
	if (hour > 24.0) hour = hour - 24.0;

							
	ivec4 temp = ToD[int(floor(hour))];
	ivec4 temp2 = ToD[int(floor(hour)) + 1];
	
	sunlight = mix(vec3(temp.yzw),vec3(temp2.yzw),(hour-float(temp.x))/float(temp2.x-temp.x))/255.0f;
	
	
		ivec4 tempa = ToD2[int(floor(hour))];
	ivec4 tempa2 = ToD2[int(floor(hour)) + 1];
	
	ambient_color = mix(vec3(tempa.yzw),vec3(tempa2.yzw),(hour-float(tempa.x))/float(tempa2.x-tempa.x))/255.0f;

	
}
