#version 120



#define WATER_REFLECTIONS
	#define WATER_REFLECTION_STRENGTH 2.0
#define BLOCK_REFLECTIONS


uniform int worldTime;
uniform sampler2D composite;
uniform sampler2D gaux2;
uniform sampler2D gaux1;
uniform sampler2D depthtex0;
uniform sampler2D gnormal;

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 fogclr;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform float far;
uniform float near;

uniform int isEyeInWater;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;

const float stp = 1.0;			//size of one step for raytracing algorithm
const float ref = 0.1;			//refinement multiplier
const float inc = 1.57;			//increasement factor at each step
const int maxf = 5;				//number of refinements

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 nvec3(vec4 pos){
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos){
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord){
    return distance(coord,vec2(0.5))*2.0;
}

float luma(vec3 color) {
return dot(color.rgb,vec3(0.299, 0.587, 0.114));
}

vec4 raytrace(vec3 fragpos, vec3 normal){
    vec4 color = vec4(0.0);
    vec3 start = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
    int sr = 0;
    for(int i=0;i<30;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1.001 || pos.y < 0 || pos.y > 1.001 || pos.z < 0 || pos.z > 1.001) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex0, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = abs(vector.z-(fragpos-spos).z);
        if(err < length(vector)*inc){
			if(texture2D(gaux2,pos.st).g < 0.01) {
                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 1.5), 0.0, 1.0);
                    color = texture2D(composite, pos.st);
					color.a = 1.0;
                    color.a *= border;
                    break;
                }
                fragpos = oldpos;
                vector *=ref;
}
}
        vector *= inc;
        oldpos = fragpos;
        fragpos += vector;
		
    }
    return color;
}


void main() {


    vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
    fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));
    vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;
    vec4 color = texture2D(composite,texcoord.xy);
	color.rgb *= mix(vec3(1.0),vec3(0.3,0.4,0.6),isEyeInWater);

#ifdef WATER_REFLECTIONS

float spec = texture2D(gaux2,texcoord.xy).r;
float wave = texture2D(gaux2,texcoord.xy).g;
float iswater = 0.0;

if (wave > 0.0){
iswater = 1.0;
wave = (wave-0.02)*2.0-1.0;
if (iswater > 0.9){

            vec4 reflection = raytrace(fragpos, normalize(normal+vec3(wave*0.05,0.0,0.0)));
			float normalDotEye = dot(normal, -normalize(fragpos));
			float fresnel = pow(1.0 - normalDotEye,5.0);


            color.rgb = mix(color.rgb, reflection.rgb*WATER_REFLECTION_STRENGTH, fresnel*reflection.a * (vec3(1.0) - color.rgb) * (1.0-isEyeInWater) * (abs(wave)+3.0)*0.25);
			color.rgb += spec*sunlight*(1.0-isEyeInWater)*(fresnel+0.75);

	}
}
#endif

#ifdef BLOCK_REFLECTIONS
	{
		vec3 aux = texture2D(gaux1, texcoord.st).rgb; 	
		vec4 reflection = raytrace(fragpos, normal);
		float totalspec = aux.r*4.0;											//NEEDS TO BE TWEAKED//
        float brigtness = 1.0 - clamp(color.r * 0.3 + color.g * 0.59 + color.b * 0.11, 0.0, 1.0);
        float reflectmask = clamp(totalspec * brigtness * 0.8f, 0.0, 1.0);

            color.rgb = mix(color.rgb, reflection.rgb, reflection.a * reflectmask);
	}
#endif

	
/* DRAWBUFFERS:NNNNNN6 */

float land = color.a;
float lum = 0.0;

float timefract = float(worldTime);
float TimeMidnight = ((clamp(timefract, 12000.0, 12750.0) - 12000.0) / 750.0) - ((clamp(timefract, 23000.0, 24000.0) - 23000.0) / 1000.0);


//Fog//
float fogfactor = pow(length(fragpos.xyz)/far,0.5);
color.rgb = mix(color.rgb,(fogclr+vec3(0.9-TimeMidnight*0.8))*0.5*(1.0-rainStrength*0.5),fogfactor*land*rainStrength);
vec2 rainmask = texture2D(gaux1,texcoord.xy).xy;
float alpha = 1.0;
if (rainmask.y > 0.65 && rainmask.y < 0.75){
rainmask.y = 1.0;
alpha = rainmask.x;
} else { 
rainmask.y = 0.00;
vec3 rainclr = vec3(0.15,0.15,0.4);
color.rgb = mix(color.rgb,rainclr,(alpha-0.08)*rainmask.y);
}

	gl_FragData[6] = vec4(color.rgb,lum);
}
