/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.core;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.ForgeVersion;
import universalelectricity.core.UELoader;

public class UniversalElectricity {
    public static final int MAJOR_VERSION = 1;
    public static final int MINOR_VERSION = 2;
    public static final int REVISION_VERSION = 1;
    public static final String VERSION = "1.2.1";
    public static final Configuration CONFIGURATION = new Configuration(new File(Loader.instance().getConfigDir(), "UniversalElectricity/UniversalElectricity.cfg"));
    public static double IC2_RATIO = 10.0;
    public static double BC3_RATIO = 85.0;
    public static double TO_IC2_RATIO = 1.0 / IC2_RATIO;
    public static double TO_BC_RATIO = 1.0 / BC3_RATIO;
    public static final agi machine = new agi(agk.h);
    public static final List mods = new ArrayList();

    public static void register(Object mod, int major, int minor, int revision, boolean strict) {
        if (1 != major) {
            throw new RuntimeException("A Universal Electricity mod is way too old! Make sure it is update to v" + major + "." + minor + "." + revision);
        }
        if (2 < minor) {
            throw new RuntimeException("A Universal Electricity mod is too old! Make sure it is update to v" + major + "." + minor + "." + revision);
        }
        if (1 < revision) {
            if (strict) {
                throw new RuntimeException("A Universal Electricity mod is too old! Require v" + major + "." + minor + "." + revision);
            }
            FMLLog.warning((String)("The version of Universal Electricity detected is not the recommended version by the mod. Odd things might happen. Recommended to try v" + major + "." + minor + "." + revision), (Object[])new Object[0]);
        }
        mods.add(mod);
        FMLLog.fine((String)(mod.getClass().getSimpleName() + " has been registered to Universal Electricity."), (Object[])new Object[0]);
        UELoader.INSTANCE.initiate();
    }

    public static void forgeLock(int major, int minor, int revision, boolean strict) {
        if (ForgeVersion.getMajorVersion() != major) {
            throw new RuntimeException("Universal Electricity: Wrong Minecraft Forge version! Require " + major + "." + minor + "." + revision);
        }
        if (ForgeVersion.getMinorVersion() < minor) {
            throw new RuntimeException("Universal Electricity: Minecraft Forge minor version is too old! Require " + major + "." + minor + "." + revision);
        }
        if (ForgeVersion.getRevisionVersion() < revision) {
            if (strict) {
                throw new RuntimeException("Universal Electricity: Minecraft Forge revision version is too old! Require " + major + "." + minor + "." + revision);
            }
            System.out.println("Universal Electricity Warning: Minecraft Forge is not the specified version. Odd things might happen. Require " + major + "." + minor + "." + revision);
        }
    }

    public static void forgeLock(int major, int minor, int revision) {
        UniversalElectricity.forgeLock(major, minor, revision, false);
    }
}

