/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.IPlayerTracker;
import cpw.mods.fml.common.registry.GameRegistry;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class UpdateNotifier
implements IPlayerTracker {
    public static final UpdateNotifier INSTANCE = new UpdateNotifier();
    public static boolean isInitialized = false;
    public static final HashMap modsToUpdate = new HashMap();

    public final String checkUpdate(String modName, String currentVersion, String updateUrl) {
        String latestUpdate;
        if (!isInitialized) {
            GameRegistry.registerPlayerTracker((IPlayerTracker)this);
            isInitialized = true;
        }
        if ((latestUpdate = UpdateNotifier.getLatestVersion(updateUrl)) != null && latestUpdate != "" && !currentVersion.trim().equals(latestUpdate.trim())) {
            modsToUpdate.put(modName, latestUpdate.trim());
        }
        return latestUpdate;
    }

    public static final String getLatestVersion(String updateUrl) {
        try {
            URL versionFile = new URL(updateUrl);
            BufferedReader reader = new BufferedReader(new InputStreamReader(versionFile.openStream()));
            return reader.readLine();
        }
        catch (Exception e) {
            FMLLog.severe((String)"Failed to check for mod updates.", (Object[])new Object[0]);
            return "";
        }
    }

    public void onPlayerLogin(qx player) {
        if (modsToUpdate.size() > 0) {
            String notification = "You have " + modsToUpdate.size() + " mod(s) that needs to be updated: ";
            for (Map.Entry pairs : modsToUpdate.entrySet()) {
                notification = notification + pairs.getKey() + " [" + pairs.getValue() + "] ";
            }
            player.b(notification);
        }
    }

    public void onPlayerLogout(qx player) {
    }

    public void onPlayerChangedDimension(qx player) {
    }

    public void onPlayerRespawn(qx player) {
    }
}

