/*
 * Decompiled with CFR 0.152.
 */
package icbm.common.jiqi;

import icbm.common.jiqi.TLeiDaTai;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import universalelectricity.core.vector.Vector2;

public class LeiDaGuanLi {
    private static List radarStations = new ArrayList();

    public static void addRadarStation(TLeiDaTai radarStation) {
        if (!radarStations.contains(radarStation)) {
            radarStations.add(radarStation);
        }
    }

    public static List getRadarStationsInArea(Vector2 minVector, Vector2 maxVector) {
        LeiDaGuanLi.cleanUpRadarArray();
        ArrayList<TLeiDaTai> returnArray = new ArrayList<TLeiDaTai>();
        for (TLeiDaTai radarStation : radarStations) {
            if (!((double)radarStation.l > minVector.x) || !((double)radarStation.l < maxVector.x) || !((double)radarStation.n > minVector.y) || !((double)radarStation.n < maxVector.y)) continue;
            returnArray.add(radarStation);
        }
        return returnArray;
    }

    public static List getRadarStations() {
        LeiDaGuanLi.cleanUpRadarArray();
        return radarStations;
    }

    public static void cleanUpRadarArray() {
        try {
            Iterator it = radarStations.iterator();
            while (it.hasNext()) {
                TLeiDaTai tileEntity = (TLeiDaTai)it.next();
                if (tileEntity == null) {
                    it.remove();
                    continue;
                }
                if (tileEntity.r()) {
                    it.remove();
                    continue;
                }
                if (tileEntity.k.q(tileEntity.l, tileEntity.m, tileEntity.n) == tileEntity) continue;
                it.remove();
            }
        }
        catch (Exception e) {
            System.out.println("Failed to clean up Radar properly.");
            e.printStackTrace();
        }
    }
}

