/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import cpw.mods.fml.common.FMLLog;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IApiaristTracker;
import forestry.api.genetics.IEffectData;
import forestry.api.genetics.IIndividual;
import forestry.core.EnumErrorCode;
import forestry.core.config.ForestryItem;
import forestry.plugins.PluginForestryApiculture;
import java.util.Stack;

public class BeekeepingLogic
implements IBeekeepingLogic {
    IBeeHousing housing;
    private int breedingTime;
    private int totalBreedingTime = 100;
    private int throttle;
    private IEffectData[] effectData = new IEffectData[2];
    private IBee queen;
    private IIndividual pollen;
    private Stack spawn = new Stack();

    public BeekeepingLogic(IBeeHousing housing) {
        this.housing = housing;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this.breedingTime = nbttagcompound.e("BreedingTime");
        this.throttle = nbttagcompound.e("Throttle");
        by nbttaglist = new by();
        ur[] offspring = this.spawn.toArray(new ur[this.spawn.size()]);
        for (int i = 0; i < offspring.length; ++i) {
            if (offspring[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            offspring[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("Offspring", (cd)nbttaglist);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        nbttagcompound.a("BreedingTime", this.breedingTime);
        nbttagcompound.a("Throttle", this.throttle);
        by nbttaglist = nbttagcompound.m("Offspring");
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            this.spawn.add(ur.a((bq)nbttagcompound1));
        }
    }

    @Override
    public int getBreedingTime() {
        return this.breedingTime;
    }

    @Override
    public int getTotalBreedingTime() {
        return this.totalBreedingTime;
    }

    @Override
    public IBee getQueen() {
        return this.queen;
    }

    @Override
    public IEffectData[] getEffectData() {
        return this.effectData;
    }

    @Override
    public void update() {
        this.resetQueen(null);
        if (!this.spawn.isEmpty()) {
            ur next = (ur)this.spawn.peek();
            if (this.housing.addProduct(next, true)) {
                this.spawn.pop();
                this.housing.setErrorState(EnumErrorCode.OK.ordinal());
            } else {
                this.housing.setErrorState(EnumErrorCode.NOSPACE.ordinal());
            }
            return;
        }
        if (this.housing.getQueen() == null) {
            this.housing.setErrorState(EnumErrorCode.NOQUEEN.ordinal());
            return;
        }
        if (this.housing.getQueen().c == ForestryItem.beePrincessGE.cj) {
            if (this.housing.getDrone() == null || this.housing.getDrone().c != ForestryItem.beeDroneGE.cj) {
                this.housing.setErrorState(EnumErrorCode.NODRONE.ordinal());
            } else {
                this.housing.setErrorState(EnumErrorCode.OK.ordinal());
            }
            this.tickBreed();
            return;
        }
        if (this.housing.getQueen().c != ForestryItem.beeQueenGE.cj) {
            this.housing.setErrorState(EnumErrorCode.NOQUEEN.ordinal());
            return;
        }
        IBee queen = BeeManager.beeInterface.getBee(this.housing.getQueen());
        if (!queen.isAlive()) {
            this.killQueen(queen);
            this.housing.setErrorState(EnumErrorCode.OK.ordinal());
            return;
        }
        this.resetQueen(queen);
        EnumErrorCode state = EnumErrorCode.values()[queen.isWorking(this.housing)];
        if (state != EnumErrorCode.OK) {
            this.housing.setErrorState(state.ordinal());
            return;
        }
        if (this.housing.getErrorOrdinal() != EnumErrorCode.NOFLOWER.ordinal()) {
            this.housing.setErrorState(EnumErrorCode.OK.ordinal());
        }
        this.effectData = queen.doEffect(this.effectData, this.housing);
        ++this.throttle;
        if (this.throttle < PluginForestryApiculture.beeCycleTicks) {
            return;
        }
        this.throttle = 0;
        if (!queen.hasFlower(this.housing)) {
            this.housing.setErrorState(EnumErrorCode.NOFLOWER.ordinal());
            return;
        }
        this.housing.setErrorState(EnumErrorCode.OK.ordinal());
        ur[] products = queen.produceStacks(this.housing);
        this.housing.wearOutEquipment(1);
        for (ur stack : products) {
            this.housing.addProduct(stack, false);
        }
        queen.plantFlowerRandom(this.housing);
        if (this.pollen == null) {
            this.pollen = queen.retrievePollen(this.housing);
        }
        if (this.pollen != null && queen.pollinateRandom(this.housing, this.pollen)) {
            this.pollen = null;
        }
        queen.age(this.housing.getWorld(), this.housing.getLifespanModifier(queen.getGenome(), queen.getMate()));
        bq nbttagcompound = new bq();
        queen.writeToNBT(nbttagcompound);
        this.housing.getQueen().d(nbttagcompound);
    }

    private void resetQueen(IBee bee) {
        this.queen = bee;
    }

    private void tickBreed() {
        if (!this.tryBreed()) {
            this.breedingTime = 0;
            return;
        }
        if (this.breedingTime < this.totalBreedingTime) {
            ++this.breedingTime;
        }
        if (this.breedingTime < this.totalBreedingTime) {
            return;
        }
        if (this.housing.getQueen() == null || this.housing.getQueen().c != ForestryItem.beePrincessGE.cj) {
            return;
        }
        IBee princess = BeeManager.beeInterface.getBee(this.housing.getQueen());
        IBee drone = BeeManager.beeInterface.getBee(this.housing.getDrone());
        princess.mate(drone);
        bq nbttagcompound = new bq();
        princess.writeToNBT(nbttagcompound);
        ur queen = new ur(ForestryItem.beeQueenGE, 1, AlleleManager.alleleRegistry.getFromUIDMap(princess.getIdent()));
        queen.d(nbttagcompound);
        this.housing.setQueen(queen);
        this.housing.onQueenChange(this.housing.getQueen());
        BeeManager.breedingManager.getApiaristTracker(this.housing.getWorld()).registerQueen(this.housing.getOwnerEntity(), princess);
        --this.housing.getDrone().a;
        if (this.housing.getDrone().a <= 0) {
            this.housing.setDrone(null);
        }
        this.breedingTime = 0;
    }

    private boolean tryBreed() {
        if (this.housing.getDrone() == null || this.housing.getQueen() == null) {
            return false;
        }
        if (this.housing.getDrone().c != ForestryItem.beeDroneGE.cj || this.housing.getQueen().c != ForestryItem.beePrincessGE.cj) {
            return false;
        }
        return this.housing.canBreed();
    }

    private void killQueen(IBee queen) {
        if (queen.canSpawn()) {
            this.spawnOffspring(queen);
            this.housing.getQueen().a = 0;
            this.housing.setQueen(null);
        } else {
            FMLLog.warning((String)"Tried to spawn offspring off an unmated queen. Devolving her to a princess.", (Object[])new Object[0]);
            ur convert = new ur(ForestryItem.beePrincessGE, 1, AlleleManager.alleleRegistry.getFromUIDMap(queen.getIdent()));
            bq nbttagcompound = new bq();
            queen.writeToNBT(nbttagcompound);
            convert.d(nbttagcompound);
            this.spawn.add(convert);
            this.housing.setQueen(null);
        }
        this.housing.onQueenChange(this.housing.getQueen());
    }

    private void spawnOffspring(IBee queen) {
        IBee[] larvae;
        bq nbttagcompound;
        Stack<ur> offspring = new Stack<ur>();
        IApiaristTracker breedingTracker = BeeManager.breedingManager.getApiaristTracker(this.housing.getWorld());
        IBee heiress = queen.spawnPrincess(this.housing);
        if (heiress != null) {
            nbttagcompound = new bq();
            ur princess = new ur(ForestryItem.beePrincessGE, 1, AlleleManager.alleleRegistry.getFromUIDMap(heiress.getIdent()));
            heiress.writeToNBT(nbttagcompound);
            princess.d(nbttagcompound);
            breedingTracker.registerPrincess(this.housing.getOwnerEntity(), heiress);
            offspring.push(princess);
        }
        for (IBee larva : larvae = queen.spawnDrones(this.housing)) {
            nbttagcompound = new bq();
            ur drone = new ur(ForestryItem.beeDroneGE, 1, AlleleManager.alleleRegistry.getFromUIDMap(larva.getIdent()));
            larva.writeToNBT(nbttagcompound);
            drone.d(nbttagcompound);
            breedingTracker.registerDrone(this.housing.getOwnerEntity(), larva);
            offspring.push(drone);
        }
        while (!offspring.isEmpty()) {
            ur spawned = (ur)offspring.pop();
            if (this.housing.addProduct(spawned, true)) continue;
            this.spawn.add(spawned);
        }
    }
}

