/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IFlowerProvider;
import forestry.core.utils.StringUtil;

public class FlowerProviderMushroom
implements IFlowerProvider {
    @Override
    public boolean isAcceptedFlower(yc world, IBeeGenome species, int x, int y2, int z) {
        int blockid = world.a(x, y2, z);
        if (blockid == amq.cf.cm) {
            return this.checkFlowerPot(world.h(x, y2, z));
        }
        return blockid == amq.ai.cm || blockid == amq.aj.cm;
    }

    private boolean checkFlowerPot(int meta) {
        return meta == 7 || meta == 8;
    }

    @Override
    public boolean growFlower(yc world, IBeeGenome species, int x, int y2, int z) {
        int blockid = world.a(x, y2, z);
        if (blockid != 0) {
            if (blockid == amq.cf.cm) {
                return this.growInPot(world, x, y2, z);
            }
            return false;
        }
        int groundid = world.a(x, y2 - 1, z);
        if (groundid != amq.bB.cm) {
            return false;
        }
        int mushroomId = world.t.nextBoolean() ? amq.ai.cm : amq.aj.cm;
        world.d(x, y2, z, mushroomId, 0);
        return true;
    }

    private boolean growInPot(yc world, int x, int y2, int z) {
        if (world.t.nextBoolean()) {
            world.d(x, y2, z, amq.cf.cm, 7);
        } else {
            world.d(x, y2, z, amq.cf.cm, 8);
        }
        return true;
    }

    @Override
    public String getDescription() {
        return StringUtil.localize("flowers.mushroom");
    }

    @Override
    public ur[] affectProducts(yc world, IBeeGenome genome, int x, int y2, int z, ur[] products) {
        return products;
    }

    @Override
    public ur[] getItemStacks() {
        return new ur[]{new ur((amq)amq.ai), new ur((amq)amq.aj)};
    }
}

