/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import cpw.mods.fml.common.network.Player;
import forestry.api.apiculture.BeeManager;
import forestry.api.core.IPacketHandler;
import forestry.api.genetics.IApiaristTracker;
import forestry.apiculture.gui.ContainerImprinter;
import forestry.core.network.PacketCoordinates;
import forestry.core.network.PacketNBT;
import forestry.core.network.PacketUpdate;
import forestry.core.proxy.Proxies;
import java.io.DataInputStream;

public class PacketHandlerApiculture
implements IPacketHandler {
    @Override
    public void onPacketData(ce network, int packetID, DataInputStream data, Player player) {
        try {
            switch (packetID) {
                case 20: {
                    PacketCoordinates packetC = new PacketCoordinates();
                    packetC.readData(data);
                    Proxies.common.setBiomeFinderCoordinates(null, packetC.getCoordinates());
                    break;
                }
                case 32: {
                    PacketUpdate packetI = new PacketUpdate();
                    packetI.readData(data);
                    this.onImprintSelection((qx)player, packetI);
                    break;
                }
                case 60: {
                    PacketNBT packetN = new PacketNBT();
                    packetN.readData(data);
                    this.onGenomeTrackerUpdate(packetN);
                    break;
                }
                case 30: {
                    PacketUpdate packet = new PacketUpdate();
                    packet.readData(data);
                    this.onImprintChange((qx)player, packet);
                    break;
                }
                case 31: {
                    this.onImprintSelectionGet((qx)player);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void onGenomeTrackerUpdate(PacketNBT packet) {
        IApiaristTracker tracker = BeeManager.breedingManager.getApiaristTracker(Proxies.common.getRenderWorld());
        tracker.decodeFromNBT(packet.getTagCompound());
    }

    private void onImprintSelection(qx player, PacketUpdate packet) {
        rq container = player.bL;
        if (!(container instanceof ContainerImprinter)) {
            return;
        }
        ((ContainerImprinter)container).setSelection(packet);
    }

    private void onImprintSelectionGet(qx playerEntity) {
        if (!(playerEntity.bL instanceof ContainerImprinter)) {
            return;
        }
        ((ContainerImprinter)playerEntity.bL).sendSelection(playerEntity);
    }

    private void onImprintChange(qx player, PacketUpdate packet) {
        if (!(player.bL instanceof ContainerImprinter)) {
            return;
        }
        ((ContainerImprinter)player.bL).handleSelectionChange(player, packet);
    }
}

