/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gadgets;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBee;
import forestry.api.core.ForestryAPI;
import forestry.core.EnumErrorCode;
import forestry.core.config.ForestryItem;
import forestry.core.gadgets.Machine;
import forestry.core.gadgets.MachineFactory;
import forestry.core.gadgets.TileMachine;
import forestry.core.network.EntityNetData;
import forestry.core.network.GuiId;
import forestry.core.utils.GenericInventoryAdapter;
import forestry.core.utils.LiquidHelper;
import forestry.core.utils.StringUtil;
import forestry.core.utils.TankSlot;
import java.util.Stack;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.LiquidContainerData;
import net.minecraftforge.liquids.LiquidStack;

public class MachineAnalyzer
extends Machine {
    public static final int TIME_TO_ANALYZE = 500;
    public static final int HONEY_REQUIRED = 100;
    public static final short SLOT_ANALYZE = 0;
    public static final short SLOT_CAN = 1;
    public static final short SLOT_INPUT_1 = 2;
    public static final short SLOT_OUTPUT_1 = 8;
    private GenericInventoryAdapter inventory = new GenericInventoryAdapter(12, "Items");
    private int analyzeTime;
    private short analyzeSlot = 0;
    private short canSlot = 1;
    private short inputSlot1 = (short)2;
    private short outputSlot1 = (short)8;
    public LiquidStack resource = new LiquidStack(ForestryItem.liquidHoney, 100);
    @EntityNetData
    public TankSlot resourceTank = new TankSlot(10000);
    private Stack pendingProducts = new Stack();

    public MachineAnalyzer(TileMachine tile) {
        super(tile);
    }

    @Override
    public String getName() {
        return StringUtil.localize("tile.mill.4");
    }

    @Override
    public void openGui(qx player, la tile) {
        player.openGui(ForestryAPI.instance, GuiId.AnalyzerGUI.ordinal(), player.p, this.tile.l, this.tile.m, this.tile.n);
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("AnalyzeTime", this.analyzeTime);
        this.resourceTank.writeToNBT(nbttagcompound);
        by nbttaglist = new by();
        ur[] pending = this.pendingProducts.toArray(new ur[this.pendingProducts.size()]);
        for (int i = 0; i < pending.length; ++i) {
            if (pending[i] == null) continue;
            bq nbttagcompound1 = new bq();
            nbttagcompound1.a("Slot", (byte)i);
            pending[i].b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("PendingProducts", (cd)nbttaglist);
        this.inventory.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.analyzeTime = nbttagcompound.e("AnalyzeTime");
        this.resourceTank.readFromNBT(nbttagcompound);
        by nbttaglist = nbttagcompound.m("PendingProducts");
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            this.pendingProducts.add(ur.a((bq)nbttagcompound1));
        }
        this.inventory.readFromNBT(nbttagcompound);
    }

    @Override
    public void updateServerSide() {
        LiquidContainerData container;
        if (this.tryAddPending()) {
            return;
        }
        if (!this.pendingProducts.isEmpty()) {
            this.setErrorState(EnumErrorCode.NOSPACE);
            return;
        }
        if (this.a(this.canSlot) != null && (container = LiquidHelper.getLiquidContainer(this.a(this.canSlot))) != null && this.resource.isLiquidEqual(container.stillLiquid)) {
            this.a((int)this.canSlot, this.replenishByContainer(this.a(this.canSlot), container, this.resourceTank));
            if (this.a((int)this.canSlot).a <= 0) {
                this.a((int)this.canSlot, null);
            }
        }
        if (this.analyzeTime > 0 && this.a(this.analyzeSlot) != null && BeeManager.beeInterface.isBee(this.a(this.analyzeSlot))) {
            --this.analyzeTime;
            if (this.analyzeTime > 0) {
                this.setErrorState(EnumErrorCode.OK);
                return;
            }
            IBee individual = BeeManager.beeInterface.getBee(this.a(this.analyzeSlot));
            if (individual == null) {
                return;
            }
            individual.analyze();
            bq nbttagcompound = new bq();
            individual.writeToNBT(nbttagcompound);
            this.a(this.analyzeSlot).d(nbttagcompound);
            this.pendingProducts.push(this.a(this.analyzeSlot));
            this.a((int)this.analyzeSlot, null);
        } else {
            this.analyzeTime = 0;
            if (this.a(this.analyzeSlot) != null) {
                return;
            }
            if (this.resourceTank.quantity < this.resource.amount) {
                this.setErrorState(EnumErrorCode.NORESOURCE);
                return;
            }
            for (int i = this.inputSlot1; i < this.outputSlot1; ++i) {
                if (this.a(i) == null || !BeeManager.beeInterface.isBee(this.a(i))) continue;
                IBee individual = BeeManager.beeInterface.getBee(this.a(i));
                if (individual.isAnalyzed()) {
                    this.pendingProducts.push(this.a(i));
                    this.a(i, null);
                    continue;
                }
                this.a((int)this.analyzeSlot, this.a(i));
                this.a(i, null);
                this.resourceTank.drain(this.resource.amount, true);
                this.analyzeTime = 500;
                return;
            }
            this.setErrorState(EnumErrorCode.NOTHINGANALYZE);
        }
    }

    @Override
    public boolean doWork() {
        return false;
    }

    private boolean tryAddPending() {
        if (this.pendingProducts.isEmpty()) {
            return false;
        }
        ur next = (ur)this.pendingProducts.peek();
        if (this.inventory.tryAddStack(next, this.outputSlot1, this.inventory.k_() - this.outputSlot1, true)) {
            this.pendingProducts.pop();
            return true;
        }
        return false;
    }

    @Override
    public boolean isWorking() {
        return this.analyzeTime > 0;
    }

    public int getProgressScaled(int i) {
        return this.analyzeTime * i / 500;
    }

    public int getResourceScaled(int i) {
        return this.resourceTank.quantity * i / 10000;
    }

    public ur getBeeOnDisplay() {
        if (this.a(this.analyzeSlot) != null) {
            return this.a(this.analyzeSlot);
        }
        return null;
    }

    @Override
    public void getGUINetworkData(int i, int j) {
        switch (i) {
            case 0: {
                this.analyzeTime = j;
                break;
            }
            case 1: {
                this.resourceTank.liquidId = j;
                break;
            }
            case 2: {
                this.resourceTank.quantity = j;
            }
        }
    }

    @Override
    public void sendGUINetworkData(rq container, rw iCrafting) {
        iCrafting.a(container, 0, this.analyzeTime);
        iCrafting.a(container, 1, this.resourceTank.liquidId);
        iCrafting.a(container, 2, this.resourceTank.quantity);
    }

    @Override
    public int k_() {
        return this.inventory.k_();
    }

    @Override
    public ur a(int i) {
        return this.inventory.a(i);
    }

    @Override
    public ur a(int i, int j) {
        return this.inventory.a(i, j);
    }

    @Override
    public void a(int i, ur itemstack) {
        this.inventory.a(i, itemstack);
    }

    @Override
    public int c() {
        return this.inventory.c();
    }

    @Override
    public ur a_(int slot) {
        return this.inventory.a_(slot);
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ur product = null;
        for (int i = this.outputSlot1; i < this.inventory.k_(); ++i) {
            if (this.inventory.a(i) == null) continue;
            product = this.a(i).l();
            if (!doRemove) break;
            this.a((int)i).a = 0;
            this.a(i, null);
            break;
        }
        return new ur[]{product};
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (!BeeManager.beeInterface.isBee(stack)) {
            LiquidContainerData container = LiquidHelper.getLiquidContainer(stack);
            if (container == null || !container.stillLiquid.isLiquidEqual(this.resource)) {
                return 0;
            }
            if (this.a(this.canSlot) == null) {
                if (doAdd) {
                    this.a((int)this.canSlot, stack.l());
                }
                return stack.a;
            }
            int space = this.a(this.canSlot).d() - this.a((int)this.canSlot).a;
            if (space <= 0) {
                return 0;
            }
            if (doAdd) {
                this.a((int)this.canSlot).a += stack.a;
                if (this.a((int)this.canSlot).a > this.a(this.canSlot).d()) {
                    this.a((int)this.canSlot).a = this.a(this.canSlot).d();
                }
            }
            return space;
        }
        for (int i = this.inputSlot1; i < this.outputSlot1; ++i) {
            if (this.a(i) != null) continue;
            if (doAdd) {
                this.a(i, stack.l());
            }
            return stack.a;
        }
        return 0;
    }

    @Override
    public int getStartInventorySide(int side) {
        if (side == 0) {
            return this.outputSlot1;
        }
        if (side == 1) {
            return this.canSlot;
        }
        return this.inputSlot1;
    }

    @Override
    public int getSizeInventorySide(int side) {
        if (side == 1) {
            return 1;
        }
        if (side == 0) {
            return 4;
        }
        return 6;
    }

    @Override
    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        if (this.resourceTank.quantity > 0 && this.resourceTank.liquidId != resource.itemID) {
            return 0;
        }
        if (resource.itemID != ForestryItem.liquidHoney.cj) {
            return 0;
        }
        int used = this.resourceTank.fill(resource, doFill);
        if (doFill && used > 0) {
            this.tile.sendNetworkUpdate();
        }
        return used;
    }

    public TankSlot[] getTanks(ForgeDirection direction) {
        return new TankSlot[]{this.resourceTank};
    }

    @Override
    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        return this.resourceTank;
    }

    public static class Factory
    extends MachineFactory {
        @Override
        public Machine createMachine(any tile) {
            return new MachineAnalyzer((TileMachine)tile);
        }
    }
}

